/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.listeners.dependencies;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import cx.ajneb97.Codex;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ResidenceListener
implements Listener {
    private Codex plugin;
    private final HashMap<UUID, String> playerRegions = new HashMap();

    public ResidenceListener(Codex plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        Residence residence = Residence.getInstance();
        if (residence == null || residence.getResidenceManager() == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        ClaimedResidence toResidence = residence.getResidenceManager().getByLoc(to);
        String toRegionName = toResidence != null ? toResidence.getName() : null;
        String fromRegionName = this.playerRegions.get(playerUUID);
        if (this.hasRegionChanged(fromRegionName, toRegionName)) {
            if (toRegionName != null) {
                this.playerRegions.put(playerUUID, toRegionName);
                this.plugin.getDiscoveryManager().onResidenceRegionEnter(player, toRegionName);
            } else {
                this.playerRegions.remove(playerUUID);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerRegions.remove(event.getPlayer().getUniqueId());
    }

    private boolean hasRegionChanged(String from, String to) {
        if (from == null && to == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        if (to == null) {
            return true;
        }
        return !from.equals(to);
    }
}

