/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.managers.dependencies.worldguard;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionsChangedEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private final UUID uuid;
    private final Set<ProtectedRegion> previousRegions = new HashSet<ProtectedRegion>();
    private final Set<ProtectedRegion> currentRegions = new HashSet<ProtectedRegion>();
    private final Set<String> previousRegionsNames = new HashSet<String>();
    private final Set<String> currentRegionsNames = new HashSet<String>();

    public RegionsChangedEvent(UUID playerUUID, @NotNull Set<ProtectedRegion> previous, @NotNull Set<ProtectedRegion> current) {
        this.uuid = playerUUID;
        this.previousRegions.addAll(previous);
        this.currentRegions.addAll(current);
        for (ProtectedRegion r : current) {
            this.currentRegionsNames.add(r.getId());
        }
        for (ProtectedRegion r : previous) {
            this.previousRegionsNames.add(r.getId());
        }
    }

    @Contract(pure=true)
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @NotNull
    public Set<String> getCurrentRegionsNames() {
        return this.currentRegionsNames;
    }

    @NotNull
    public Set<String> getPreviousRegionsNames() {
        return this.previousRegionsNames;
    }

    @NotNull
    public Set<ProtectedRegion> getCurrentRegions() {
        return this.currentRegions;
    }

    @NotNull
    public Set<ProtectedRegion> getPreviousRegions() {
        return this.previousRegions;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

