/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.managers.dependencies.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.handler.Handler;
import cx.ajneb97.Codex;
import cx.ajneb97.managers.dependencies.worldguard.WorldGuardEntryManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardManager {
    private Codex plugin;
    private RegionContainer container;

    public WorldGuardManager(Codex plugin) {
        this.plugin = plugin;
        this.container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)WorldGuardEntryManager.factory, null);
    }

    public Set<ProtectedRegion> getRegions(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null || !player.isOnline()) {
            return Collections.emptySet();
        }
        RegionQuery query = this.container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)player.getLocation()));
        return set.getRegions();
    }

    public Set<String> getRegionsNames(UUID playerUUID) {
        return this.getRegions(playerUUID).stream().map(ProtectedRegion::getId).collect(Collectors.toSet());
    }

    public boolean isPlayerInAllRegions(UUID playerUUID, Set<String> regionNames) {
        Set<String> regions = this.getRegionsNames(playerUUID);
        if (regionNames.isEmpty()) {
            throw new IllegalArgumentException("You need to check for at least one region !");
        }
        return regions.containsAll(regionNames.stream().map(String::toLowerCase).collect(Collectors.toSet()));
    }

    public boolean isPlayerInAnyRegion(UUID playerUUID, Set<String> regionNames) {
        Set<String> regions = this.getRegionsNames(playerUUID);
        if (regionNames.isEmpty()) {
            throw new IllegalArgumentException("You need to check for at least one region !");
        }
        for (String region : regionNames) {
            if (!regions.contains(region.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerInAnyRegion(UUID playerUUID, String ... regionName) {
        return this.isPlayerInAnyRegion(playerUUID, new HashSet<String>(Arrays.asList(regionName)));
    }

    public boolean isPlayerInAllRegions(UUID playerUUID, String ... regionName) {
        return this.isPlayerInAllRegions(playerUUID, new HashSet<String>(Arrays.asList(regionName)));
    }
}

