/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.model.data;

import cx.ajneb97.model.data.PlayerDataDiscovery;
import java.util.ArrayList;
import java.util.List;

public class PlayerDataCategory {
    private String name;
    private boolean completed;
    private ArrayList<PlayerDataDiscovery> discoveries;

    public PlayerDataCategory(String name, boolean completed, ArrayList<PlayerDataDiscovery> discoveries) {
        this.name = name;
        this.completed = completed;
        this.discoveries = discoveries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<PlayerDataDiscovery> getDiscoveries() {
        return this.discoveries;
    }

    public void setDiscoveries(ArrayList<PlayerDataDiscovery> discoveries) {
        this.discoveries = discoveries;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public PlayerDataDiscovery getDiscovery(String discoveryName) {
        for (PlayerDataDiscovery d : this.discoveries) {
            if (!d.getDiscoveryName().equals(discoveryName)) continue;
            return d;
        }
        return null;
    }

    public void addDiscovery(PlayerDataDiscovery discovery) {
        this.discoveries.add(discovery);
    }

    public boolean hasDiscovery(String discoveryName) {
        return this.getDiscovery(discoveryName) != null;
    }

    public void setMillisActionsExecuted(String discoveryName) {
        PlayerDataDiscovery d = this.getDiscovery(discoveryName);
        if (d != null) {
            d.setMillisActionsExecuted(System.currentTimeMillis());
        }
    }

    public long getMillisActionsExecuted(String discoveryName) {
        PlayerDataDiscovery d = this.getDiscovery(discoveryName);
        if (d != null) {
            return d.getMillisActionsExecuted();
        }
        return 0L;
    }

    public void resetDiscovery(String discoveryName) {
        this.discoveries.removeIf(d -> d.getDiscoveryName().equals(discoveryName));
    }

    public List<String> getDiscoveriesToStringList() {
        ArrayList<String> list = new ArrayList<String>();
        for (PlayerDataDiscovery d : this.discoveries) {
            list.add(d.getDiscoveryName() + ";" + d.getDiscoverDate() + ";" + d.getMillisActionsExecuted());
        }
        return list;
    }
}

