/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97;

import cx.ajneb97.api.CodexAPI;
import cx.ajneb97.api.ExpansionCodex;
import cx.ajneb97.commands.MainCommand;
import cx.ajneb97.config.ConfigsManager;
import cx.ajneb97.database.MySQLConnection;
import cx.ajneb97.listeners.InventoryListener;
import cx.ajneb97.listeners.PlayerListener;
import cx.ajneb97.listeners.dependencies.EliteMobsListener;
import cx.ajneb97.listeners.dependencies.MythicMobsListener;
import cx.ajneb97.listeners.dependencies.WorldGuardListener;
import cx.ajneb97.managers.CategoryManager;
import cx.ajneb97.managers.CommonItemManager;
import cx.ajneb97.managers.DiscoveryManager;
import cx.ajneb97.managers.InventoryManager;
import cx.ajneb97.managers.MessagesManager;
import cx.ajneb97.managers.PlayerDataManager;
import cx.ajneb97.managers.UpdateCheckerManager;
import cx.ajneb97.managers.VerifyManager;
import cx.ajneb97.managers.dependencies.DependencyManager;
import cx.ajneb97.managers.dependencies.Metrics;
import cx.ajneb97.model.internal.UpdateCheckerResult;
import cx.ajneb97.tasks.PlayerDataSaveTask;
import cx.ajneb97.utils.ServerVersion;
import cx.ajneb97.versions.NMSManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Codex
extends JavaPlugin {
    PluginDescriptionFile pdfFile = this.getDescription();
    public String version = this.pdfFile.getVersion();
    public static String prefix;
    public static ServerVersion serverVersion;
    private ConfigsManager configsManager;
    private NMSManager nmsManager;
    private CommonItemManager commonItemManager;
    private MessagesManager messagesManager;
    private InventoryManager inventoryManager;
    private CategoryManager categoryManager;
    private DiscoveryManager discoveryManager;
    private DependencyManager dependencyManager;
    private PlayerDataManager playerDataManager;
    private MySQLConnection mySQLConnection;
    private PlayerDataSaveTask playerDataSaveTask;
    private UpdateCheckerManager updateCheckerManager;
    private VerifyManager verifyManager;

    public void onEnable() {
        this.setVersion();
        this.setPrefix();
        this.playerDataManager = new PlayerDataManager(this);
        this.inventoryManager = new InventoryManager(this);
        this.commonItemManager = new CommonItemManager(this);
        this.categoryManager = new CategoryManager(this);
        this.discoveryManager = new DiscoveryManager(this);
        this.dependencyManager = new DependencyManager(this);
        this.nmsManager = new NMSManager(this);
        this.configsManager = new ConfigsManager(this);
        this.configsManager.configure();
        if (this.configsManager.getMainConfigManager().getConfigVersion() != 2) {
            this.legacyVersionError();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerEvents();
        this.registerCommands();
        this.reloadPlayerDataSaveTask();
        CodexAPI api = new CodexAPI(this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ExpansionCodex(this).register();
        }
        Metrics metrics = new Metrics(this, 24230);
        this.verifyManager = new VerifyManager(this);
        this.verifyManager.verify();
        if (this.configsManager.getMainConfigManager().isMySQL()) {
            this.mySQLConnection = new MySQLConnection(this);
            this.mySQLConnection.setupMySql();
        }
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eHas been enabled! &fVersion: " + this.version));
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eThanks for using my plugin!   &f~Ajneb97"));
        this.updateCheckerManager = new UpdateCheckerManager(this.version);
        this.updateMessage(this.updateCheckerManager.check());
    }

    public void onDisable() {
        this.configsManager.getPlayersConfigManager().saveConfigs();
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eHas been disabled! &fVersion: " + this.version));
    }

    public void registerCommands() {
        this.getCommand("codex").setExecutor((CommandExecutor)new MainCommand(this));
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        if (this.dependencyManager.getWorldGuardManager() != null) {
            pm.registerEvents((Listener)new WorldGuardListener(this), (Plugin)this);
        }
        if (this.dependencyManager.isMythicMobs()) {
            pm.registerEvents((Listener)new MythicMobsListener(this), (Plugin)this);
        }
        if (this.dependencyManager.isEliteMobs()) {
            pm.registerEvents((Listener)new EliteMobsListener(this), (Plugin)this);
        }
    }

    public void setPrefix() {
        prefix = MessagesManager.getColoredMessage("&4[&cCodex&4] ");
    }

    public void setVersion() {
        String bukkitVersion;
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        switch (bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0]) {
            case "1.20.5": 
            case "1.20.6": {
                serverVersion = ServerVersion.v1_20_R4;
                break;
            }
            case "1.21": 
            case "1.21.1": {
                serverVersion = ServerVersion.v1_21_R1;
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                serverVersion = ServerVersion.v1_21_R2;
                break;
            }
            case "1.21.4": {
                serverVersion = ServerVersion.v1_21_R3;
                break;
            }
            case "1.21.5": {
                serverVersion = ServerVersion.v1_21_R4;
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                serverVersion = ServerVersion.v1_21_R5;
                break;
            }
            case "1.21.9": {
                serverVersion = ServerVersion.v1_21_R6;
                break;
            }
            default: {
                try {
                    serverVersion = ServerVersion.valueOf(packageName.replace("org.bukkit.craftbukkit.", ""));
                    break;
                }
                catch (Exception e) {
                    serverVersion = ServerVersion.v1_21_R6;
                }
            }
        }
    }

    public void reloadPlayerDataSaveTask() {
        if (this.playerDataSaveTask != null) {
            this.playerDataSaveTask.end();
        }
        this.playerDataSaveTask = new PlayerDataSaveTask(this);
        this.playerDataSaveTask.start(this.configsManager.getMainConfigManager().getPlayerDataSave());
    }

    public CommonItemManager getCommonItemManager() {
        return this.commonItemManager;
    }

    public ConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public NMSManager getNmsManager() {
        return this.nmsManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public void setMessagesManager(MessagesManager messagesManager) {
        this.messagesManager = messagesManager;
    }

    public FileConfiguration getMessagesConfig() {
        return this.configsManager.getMessagesConfigManager().getConfigFile().getConfig();
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public MySQLConnection getMySQLConnection() {
        return this.mySQLConnection;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public DiscoveryManager getDiscoveryManager() {
        return this.discoveryManager;
    }

    public VerifyManager getVerifyManager() {
        return this.verifyManager;
    }

    public void updateMessage(UpdateCheckerResult result) {
        if (!result.isError()) {
            String latestVersion = result.getLatestVersion();
            if (latestVersion != null) {
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cThere is a new version available. &e(&7" + latestVersion + "&e)"));
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cYou can download it at: &fhttps://modrinth.com/plugin/codex-rpg-discoveries"));
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &cError while checking update."));
        }
    }

    public UpdateCheckerManager getUpdateCheckerManager() {
        return this.updateCheckerManager;
    }

    public void legacyVersionError() {
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&cERROR ENABLING THE PLUGIN!"));
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cYour current config is not supported by the newer"));
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cversions of the plugin. More information on the"));
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cfollowing link: &fhttps://www.spigotmc.org/resources/90371/"));
    }
}

