/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.config;

import cx.ajneb97.Codex;
import cx.ajneb97.config.CommonConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;

public class MainConfigManager {
    private Codex plugin;
    private CommonConfig configFile;
    private boolean isMySQL;
    private boolean updateNotify;
    private String discoveriesDateFormat;
    private int playerDataSave;
    private String progressBarPlaceholderFillSymbol;
    private String progressBarPlaceholderEmptySymbol;
    private int progressBarPlaceholderAmount;
    private int configVersion;

    public MainConfigManager(Codex plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.isMySQL = config.getBoolean("mysql_database.enabled");
        this.updateNotify = config.getBoolean("update_notify");
        this.discoveriesDateFormat = config.getString("discoveries_date_format");
        this.playerDataSave = config.getInt("player_data_save");
        this.progressBarPlaceholderFillSymbol = config.getString("progress_bar_placeholder.filled_symbol");
        this.progressBarPlaceholderEmptySymbol = config.getString("progress_bar_placeholder.empty_symbol");
        this.progressBarPlaceholderAmount = config.getInt("progress_bar_placeholder.amount");
        this.configVersion = config.getInt("config_version");
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public void checkUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            if (!text.contains("verifyServerCertificate:")) {
                this.getConfig().set("mysql_database.pool.connectionTimeout", (Object)5000);
                this.getConfig().set("mysql_database.advanced.verifyServerCertificate", (Object)false);
                this.getConfig().set("mysql_database.advanced.useSSL", (Object)true);
                this.getConfig().set("mysql_database.advanced.allowPublicKeyRetrieval", (Object)true);
                this.configFile.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isUpdateNotify() {
        return this.updateNotify;
    }

    public String getDiscoveriesDateFormat() {
        return this.discoveriesDateFormat;
    }

    public int getPlayerDataSave() {
        return this.playerDataSave;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public String getProgressBarPlaceholderFillSymbol() {
        return this.progressBarPlaceholderFillSymbol;
    }

    public String getProgressBarPlaceholderEmptySymbol() {
        return this.progressBarPlaceholderEmptySymbol;
    }

    public int getProgressBarPlaceholderAmount() {
        return this.progressBarPlaceholderAmount;
    }
}

