/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.database;

import cx.ajneb97.Codex;
import cx.ajneb97.database.HikariConnection;
import cx.ajneb97.database.PlayerCallback;
import cx.ajneb97.managers.MessagesManager;
import cx.ajneb97.model.data.PlayerData;
import cx.ajneb97.model.data.PlayerDataCategory;
import cx.ajneb97.model.data.PlayerDataDiscovery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MySQLConnection {
    private Codex plugin;
    private HikariConnection connection;

    public MySQLConnection(Codex plugin) {
        this.plugin = plugin;
    }

    public void setupMySql() {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        try {
            this.connection = new HikariConnection(config);
            this.connection.getHikari().getConnection();
            this.createTables();
            this.loadData();
            Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(Codex.prefix + "&aSuccessfully connected to the Database."));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(Codex.prefix + "&cError while connecting to the Database."));
        }
    }

    public Connection getConnection() {
        try {
            return this.connection.getHikari().getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadData() {
        HashMap<UUID, PlayerData> playerMap = new HashMap<UUID, PlayerData>();
        try (Connection connection = this.getConnection();){
            PreparedStatement statement = connection.prepareStatement("SELECT codex_players.UUID, codex_players.PLAYER_NAME, (SELECT GROUP_CONCAT(cc.Category) FROM codex_players_completed_categories cc WHERE cc.UUID = codex_players.UUID) AS COMPLETED_CATEGORIES, codex_players_discoveries.CATEGORY AS DISCOVERY_CATEGORY, codex_players_discoveries.DISCOVERY, codex_players_discoveries.DATE, codex_players_discoveries.MILLIS_ACTIONS_EXECUTED FROM codex_players LEFT JOIN codex_players_discoveries ON codex_players.UUID = codex_players_discoveries.UUID");
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                UUID uuid = UUID.fromString(result.getString("UUID"));
                String playerName = result.getString("PLAYER_NAME");
                String completedCategories = result.getString("COMPLETED_CATEGORIES");
                String discoveryCategoryName = result.getString("DISCOVERY_CATEGORY");
                String discoveryName = result.getString("DISCOVERY");
                String discoveryDate = result.getString("DATE");
                long discoveryMillisActionsExecuted = result.getLong("MILLIS_ACTIONS_EXECUTED");
                PlayerData player = (PlayerData)playerMap.get(uuid);
                if (player == null) {
                    player = new PlayerData(uuid, playerName);
                    playerMap.put(uuid, player);
                }
                if (discoveryCategoryName == null) continue;
                boolean hasCompletedCategory = completedCategories != null && completedCategories.contains(discoveryCategoryName);
                PlayerDataCategory playerDataCategory = player.getCategory(discoveryCategoryName);
                if (playerDataCategory == null) {
                    playerDataCategory = new PlayerDataCategory(discoveryCategoryName, hasCompletedCategory, new ArrayList<PlayerDataDiscovery>());
                    player.getCategories().add(playerDataCategory);
                }
                playerDataCategory.getDiscoveries().add(new PlayerDataDiscovery(discoveryName, discoveryDate, discoveryMillisActionsExecuted));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.plugin.getPlayerDataManager().setPlayers(playerMap);
    }

    public void createTables() {
        try (Connection connection = this.getConnection();){
            PreparedStatement statement1 = connection.prepareStatement("CREATE TABLE IF NOT EXISTS codex_players (UUID varchar(36) NOT NULL,  PLAYER_NAME varchar(50),  PRIMARY KEY ( UUID ))");
            statement1.executeUpdate();
            PreparedStatement statement2 = connection.prepareStatement("CREATE TABLE IF NOT EXISTS codex_players_discoveries (ID int NOT NULL AUTO_INCREMENT,  UUID varchar(36) NOT NULL,  CATEGORY varchar(100),  DISCOVERY varchar(100),  DATE varchar(100),  MILLIS_ACTIONS_EXECUTED bigint,  PRIMARY KEY ( ID ),  FOREIGN KEY (UUID) REFERENCES codex_players(UUID))");
            statement2.executeUpdate();
            PreparedStatement statement3 = connection.prepareStatement("CREATE TABLE IF NOT EXISTS codex_players_completed_categories (ID int NOT NULL AUTO_INCREMENT,  UUID varchar(36) NOT NULL,  CATEGORY varchar(100),  PRIMARY KEY ( ID ),  FOREIGN KEY (UUID) REFERENCES codex_players(UUID))");
            statement3.executeUpdate();
            DatabaseMetaData dbm = connection.getMetaData();
            ResultSet rs = dbm.getColumns(null, null, "codex_players_discoveries", "MILLIS_ACTIONS_EXECUTED");
            if (!rs.next()) {
                PreparedStatement alterStatement = connection.prepareStatement("ALTER TABLE codex_players_discoveries ADD COLUMN MILLIS_ACTIONS_EXECUTED bigint");
                alterStatement.executeUpdate();
                alterStatement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getPlayer(final String uuid, final PlayerCallback callback) {
        new BukkitRunnable(){

            public void run() {
                PlayerData player = null;
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = connection.prepareStatement("SELECT codex_players.UUID, codex_players.PLAYER_NAME, (SELECT GROUP_CONCAT(cc.Category) FROM codex_players_completed_categories cc WHERE cc.UUID = codex_players.UUID) AS COMPLETED_CATEGORIES, codex_players_discoveries.CATEGORY AS DISCOVERY_CATEGORY, codex_players_discoveries.DISCOVERY, codex_players_discoveries.DATE, codex_players_discoveries.MILLIS_ACTIONS_EXECUTED FROM codex_players LEFT JOIN codex_players_discoveries ON codex_players.UUID = codex_players_discoveries.UUID WHERE codex_players.UUID = ?");
                    statement.setString(1, uuid);
                    ResultSet result = statement.executeQuery();
                    while (result.next()) {
                        UUID uuid2 = UUID.fromString(result.getString("UUID"));
                        String playerName = result.getString("PLAYER_NAME");
                        String completedCategories = result.getString("COMPLETED_CATEGORIES");
                        String discoveryCategoryName = result.getString("DISCOVERY_CATEGORY");
                        String discoveryName = result.getString("DISCOVERY");
                        String discoveryDate = result.getString("DATE");
                        long discoveryMillisActionsExecuted = result.getLong("MILLIS_ACTIONS_EXECUTED");
                        if (player == null) {
                            player = new PlayerData(uuid2, playerName);
                        }
                        if (discoveryCategoryName == null) continue;
                        boolean hasCompletedCategory = completedCategories != null && completedCategories.contains(discoveryCategoryName);
                        PlayerDataCategory playerDataCategory = player.getCategory(discoveryCategoryName);
                        if (playerDataCategory == null) {
                            playerDataCategory = new PlayerDataCategory(discoveryCategoryName, hasCompletedCategory, new ArrayList<PlayerDataDiscovery>());
                            player.getCategories().add(playerDataCategory);
                        }
                        playerDataCategory.getDiscoveries().add(new PlayerDataDiscovery(discoveryName, discoveryDate, discoveryMillisActionsExecuted));
                    }
                    final PlayerData finalPlayer = player;
                    new BukkitRunnable(){

                        public void run() {
                            callback.onDone(finalPlayer);
                        }
                    }.runTask((Plugin)MySQLConnection.this.plugin);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void createPlayer(final PlayerData player) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = connection.prepareStatement("INSERT INTO codex_players (UUID, PLAYER_NAME) VALUE (?,?)");
                    statement.setString(1, player.getUuid().toString());
                    statement.setString(2, player.getName());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void updatePlayerName(final PlayerData player) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = connection.prepareStatement("UPDATE codex_players SET PLAYER_NAME=? WHERE UUID=?");
                    statement.setString(1, player.getName());
                    statement.setString(2, player.getUuid().toString());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void addDiscovery(final String uuid, final String categoryName, final String discoveryName, final String discoveryDate) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = null;
                    statement = connection.prepareStatement("INSERT INTO codex_players_discoveries (UUID, CATEGORY, DISCOVERY, DATE, MILLIS_ACTIONS_EXECUTED) VALUE (?,?,?,?,?)");
                    statement.setString(1, uuid);
                    statement.setString(2, categoryName);
                    statement.setString(3, discoveryName);
                    statement.setString(4, discoveryDate);
                    statement.setLong(5, 0L);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void updateMillisActionsExecuted(final String uuid, final String categoryName, final String discoveryName) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = connection.prepareStatement("UPDATE codex_players_discoveries SET MILLIS_ACTIONS_EXECUTED=? WHERE UUID=? AND CATEGORY=? AND DISCOVERY=?");
                    statement.setLong(1, System.currentTimeMillis());
                    statement.setString(2, uuid);
                    statement.setString(3, categoryName);
                    statement.setString(4, discoveryName);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void updateCompletedCategories(final String uuid, final String categoryName) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = null;
                    statement = connection.prepareStatement("INSERT INTO codex_players_completed_categories (UUID, CATEGORY) VALUE (?,?)");
                    statement.setString(1, uuid);
                    statement.setString(2, categoryName);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void resetDataPlayer(final String uuid, final String categoryName, final String discoveryName) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLConnection.this.getConnection();){
                    PreparedStatement statement = null;
                    PreparedStatement statement2 = null;
                    if (categoryName == null) {
                        if (uuid.equals("*")) {
                            statement = connection.prepareStatement("DELETE FROM codex_players_discoveries");
                            statement2 = connection.prepareStatement("DELETE FROM codex_players_completed_categories");
                        } else {
                            statement = connection.prepareStatement("DELETE FROM codex_players_discoveries WHERE UUID=?");
                            statement.setString(1, uuid);
                            statement2 = connection.prepareStatement("DELETE FROM codex_players_completed_categories WHERE UUID=?");
                            statement2.setString(1, uuid);
                        }
                    } else if (discoveryName == null) {
                        if (uuid.equals("*")) {
                            statement = connection.prepareStatement("DELETE FROM codex_players_discoveries WHERE CATEGORY=?");
                            statement.setString(1, categoryName);
                            statement2 = connection.prepareStatement("DELETE FROM codex_players_completed_categories WHERE CATEGORY=?");
                            statement2.setString(1, categoryName);
                        } else {
                            statement = connection.prepareStatement("DELETE FROM codex_players_discoveries WHERE UUID=? AND CATEGORY=?");
                            statement.setString(1, uuid);
                            statement.setString(2, categoryName);
                            statement2 = connection.prepareStatement("DELETE FROM codex_players_completed_categories WHERE UUID=? AND CATEGORY=?");
                            statement2.setString(1, uuid);
                            statement2.setString(2, categoryName);
                        }
                    } else if (uuid.equals("*")) {
                        statement = connection.prepareStatement("DELETE FROM codex_players_discoveries WHERE CATEGORY=? AND DISCOVERY=?");
                        statement.setString(1, categoryName);
                        statement.setString(2, discoveryName);
                    } else {
                        statement = connection.prepareStatement("DELETE FROM codex_players_discoveries WHERE UUID=? AND CATEGORY=? AND DISCOVERY=?");
                        statement.setString(1, uuid);
                        statement.setString(2, categoryName);
                        statement.setString(3, discoveryName);
                    }
                    statement.executeUpdate();
                    if (statement2 != null) {
                        statement2.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

