/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.libs.hikaricp.metrics.prometheus;

import cx.ajneb97.libs.hikaricp.metrics.IMetricsTracker;
import cx.ajneb97.libs.hikaricp.metrics.MetricsTrackerFactory;
import cx.ajneb97.libs.hikaricp.metrics.PoolStats;
import cx.ajneb97.libs.hikaricp.metrics.prometheus.HikariCPCollector;
import cx.ajneb97.libs.hikaricp.metrics.prometheus.PrometheusHistogramMetricsTracker;
import cx.ajneb97.libs.hikaricp.metrics.prometheus.PrometheusMetricsTrackerFactory;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PrometheusHistogramMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> registrationStatuses = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusHistogramMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusHistogramMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(poolName, poolStats);
        return new PrometheusHistogramMetricsTracker(poolName, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }
}

