/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.managers;

import cx.ajneb97.Codex;
import cx.ajneb97.managers.CategoryManager;
import cx.ajneb97.managers.InventoryManager;
import cx.ajneb97.managers.MessagesManager;
import cx.ajneb97.model.inventory.CommonInventory;
import cx.ajneb97.model.inventory.CommonInventoryItem;
import cx.ajneb97.model.item.CommonItem;
import cx.ajneb97.model.structure.Category;
import cx.ajneb97.model.structure.Discovery;
import cx.ajneb97.model.verify.CodexActionError;
import cx.ajneb97.model.verify.CodexBaseError;
import cx.ajneb97.model.verify.CodexInvalidItem;
import cx.ajneb97.model.verify.CodexInventoryDefaultNotExistsError;
import cx.ajneb97.model.verify.CodexInventoryInvalidCategoryError;
import cx.ajneb97.model.verify.CodexInventoryInvalidDiscoveryError;
import cx.ajneb97.model.verify.CodexInventoryInvalidSlotError;
import cx.ajneb97.model.verify.CodexInventoryNotExistsError;
import cx.ajneb97.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class VerifyManager {
    private Codex plugin;
    private ArrayList<CodexBaseError> errors;
    private boolean criticalErrors;

    public VerifyManager(Codex plugin) {
        this.plugin = plugin;
        this.errors = new ArrayList();
        this.criticalErrors = false;
    }

    public void sendVerification(Player player) {
        player.sendMessage(MessagesManager.getColoredMessage("&f&l- - - - - - - - &6&lCODEX VERIFY &f&l- - - - - - - -"));
        player.sendMessage(MessagesManager.getColoredMessage(""));
        if (this.errors.isEmpty()) {
            player.sendMessage(MessagesManager.getColoredMessage("&aThere are no errors in the plugin ;)"));
        } else {
            player.sendMessage(MessagesManager.getColoredMessage("&e&oHover on the errors to see more information."));
            for (CodexBaseError error : this.errors) {
                error.sendMessage(player);
            }
        }
        player.sendMessage(MessagesManager.getColoredMessage(""));
        player.sendMessage(MessagesManager.getColoredMessage("&f&l- - - - - - - - &6&lCODEX VERIFY &f&l- - - - - - - -"));
    }

    public void verify() {
        this.errors = new ArrayList();
        this.criticalErrors = false;
        ArrayList<Category> categories = this.plugin.getCategoryManager().getCategories();
        for (Category category : categories) {
            this.verifyCategory(category);
        }
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        ArrayList<CommonInventory> inventories = inventoryManager.getInventories();
        for (CommonInventory inventory : inventories) {
            this.verifyInventory(inventory);
        }
        if (inventoryManager.getInventory("main_inventory") == null) {
            this.errors.add(new CodexInventoryDefaultNotExistsError("inventory.yml", null, true, "main_inventory"));
            this.criticalErrors = true;
        }
    }

    public void verifyCategory(Category category) {
        this.verifyActions(category.getDefaultRewardsPerDiscovery(), "category rewards per_discovery", category.getName() + ".yml");
        this.verifyActions(category.getDefaultRewardsAllDiscoveries(), "category rewards all_discoveries", category.getName() + ".yml");
        for (Discovery d : category.getDiscoveries()) {
            this.verifyActions(d.getCustomRewards(), d.getId() + " rewards", category.getName() + ".yml");
            this.verifyActions(d.getClickActions(), d.getId() + " click_actions", category.getName() + ".yml");
        }
        ArrayList<CommonItem> allItems = new ArrayList<CommonItem>();
        allItems.add(category.getCategoryItem());
        allItems.add(category.getDefaultLevelBlockedItem());
        allItems.add(category.getDefaultLevelUnlockedItem());
        for (Discovery d : category.getDiscoveries()) {
            allItems.add(d.getCustomLevelBlockedItem());
            allItems.add(d.getCustomLevelUnlockedItem());
        }
        for (CommonItem item : allItems) {
            if (item == null || this.verifyItem(item.getId())) continue;
            this.errors.add(new CodexInvalidItem(category.getName() + ".yml", null, true, item.getId()));
            this.criticalErrors = true;
        }
    }

    public void verifyActions(List<String> actions, String actionGroup, String fileName) {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            String[] actionText;
            String actionName;
            if (actions.get(i).equals("close_inventory") || (actionName = (actionText = actions.get(i).split(" "))[0]).equals("console_command:") || actionName.equals("player_command:") || actionName.equals("playsound:") || actionName.equals("message:") || actionName.equals("centered_message:") || actionName.equals("title:")) continue;
            this.errors.add(new CodexActionError(fileName, actions.get(i), false, actionGroup, i + 1 + ""));
        }
    }

    public void verifyInventory(CommonInventory inventory) {
        CategoryManager categoryManager = this.plugin.getCategoryManager();
        List<CommonInventoryItem> items = inventory.getItems();
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        int maxSlots = inventory.getSlots();
        for (CommonInventoryItem item : items) {
            CommonItem commonItem;
            String openInventory;
            String type = item.getType();
            if (type != null) {
                if (type.startsWith("category: ")) {
                    String categoryName = type.replace("category: ", "");
                    if (categoryManager.getCategory(categoryName) == null) {
                        this.errors.add(new CodexInventoryInvalidCategoryError("inventory.yml", null, true, categoryName, inventory.getName(), item.getSlotsString()));
                        this.criticalErrors = true;
                    }
                } else if (type.startsWith("discovery: ")) {
                    String discoveryName = type.replace("discovery: ", "");
                    String categoryName = inventory.getName().replace("category_", "").split(";")[0];
                    Category category = categoryManager.getCategory(categoryName);
                    if (category == null || category.getDiscovery(discoveryName) == null) {
                        this.errors.add(new CodexInventoryInvalidDiscoveryError("inventory.yml", null, true, discoveryName, categoryName, inventory.getName(), item.getSlotsString()));
                        this.criticalErrors = true;
                    }
                }
            }
            if ((openInventory = item.getOpenInventory()) != null && inventoryManager.getInventory(openInventory) == null) {
                this.errors.add(new CodexInventoryNotExistsError("inventory.yml", null, true, inventory.getName(), item.getSlotsString(), openInventory));
                this.criticalErrors = true;
            }
            if ((commonItem = item.getItem()) != null && !this.verifyItem(commonItem.getId())) {
                this.errors.add(new CodexInvalidItem("inventory.yml", null, true, commonItem.getId()));
                this.criticalErrors = true;
            }
            for (int slot : item.getSlots()) {
                if (slot < maxSlots) continue;
                this.errors.add(new CodexInventoryInvalidSlotError("inventory.yml", null, true, slot, inventory.getName(), maxSlots));
                this.criticalErrors = true;
            }
        }
    }

    public boolean isCriticalErrors() {
        return this.criticalErrors;
    }

    public boolean verifyItem(String material) {
        try {
            ItemUtils.createItemFromID(material);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

