/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.scale.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.juyoh.scale.recipe.ModRecipes;
import net.juyoh.scale.recipe.StretchingRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record StretchingRecipe(Ingredient input, ItemStack output) implements Recipe<StretchingRecipeInput>
{
    public boolean matches(StretchingRecipeInput stretchingRecipeInput, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(stretchingRecipeInput.getItem(0));
    }

    public ItemStack assemble(StretchingRecipeInput stretchingRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.STRETCHING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.STRETCHING_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public static class Serializer
    implements RecipeSerializer<StretchingRecipe> {
        public static final MapCodec<StretchingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(StretchingRecipe::input), (App)ItemStack.CODEC.fieldOf("result").forGetter(StretchingRecipe::output)).apply((Applicative)inst, StretchingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, StretchingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, StretchingRecipe::input, (StreamCodec)ItemStack.STREAM_CODEC, StretchingRecipe::output, StretchingRecipe::new);

        public MapCodec<StretchingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, StretchingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

