/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.scale.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.juyoh.scale.Upsizing;
import net.juyoh.scale.item.ResizerItem;
import net.juyoh.scale.item.component.ModItemComponents;
import net.juyoh.scale.item.component.ResizerAmountComponent;
import net.juyoh.scale.network.ResizerConfigSyncPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleTypes;

public class ResizerScreen
extends Screen {
    ResizerItem item;
    ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"upsizing", (String)"textures/gui/resizer.png");
    int textureWidth = 182;
    int textureHeight = 103;
    InteractionHand hand;
    float resizeAmount;

    public ResizerScreen(ResizerItem item, InteractionHand usedHand) {
        super((Component)Component.literal((String)"Resizer"));
        this.item = item;
        this.hand = usedHand;
    }

    public ResizerScreen(ResizerItem item, InteractionHand usedHand, float resizeAmount) {
        super((Component)Component.literal((String)"Resizer"));
        this.item = item;
        this.hand = usedHand;
        this.resizeAmount = resizeAmount;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.textureWidth) / 2;
        int y = (this.height - this.textureHeight) / 2;
        Upsizing.LOGGER.info(x + ", " + y);
        TooltipArea sizeTooltip = new TooltipArea(x - 2, y + 32, 32, 32).withTooltip(List.of(Component.translatable((String)"message.upsizing.scale")));
        ScrollInput scrollInput = new ScrollInput(x + 32, y + 48, 110, 21).withRange(0, 128).calling(integer -> {
            this.resizeAmount = integer.intValue();
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * this.resizeAmount / 128.0f)));
        });
        IconButton confirm = (IconButton)new IconButton(x + this.textureWidth - 33, y + this.textureHeight - 24, (ScreenElement)AllIcons.I_CONFIRM).withCallback(this::onClose);
        this.addRenderableWidget((GuiEventListener)scrollInput);
        this.addRenderableWidget((GuiEventListener)confirm);
        this.addRenderableWidget((GuiEventListener)sizeTooltip);
    }

    protected void renderMenuBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height) {
        int x = (width - this.textureWidth) / 2;
        int y = (height - this.textureHeight) / 2;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.textureWidth, this.textureHeight);
        super.renderMenuBackground(guiGraphics, mouseX, mouseY, width, height);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - this.textureWidth) / 2;
        int y = (this.height - this.textureHeight) / 2;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawInputBox(guiGraphics, x + 32, y + 48);
        MutableComponent scaleText = Component.translatable((String)"message.upsizing.scale");
        this.drawItem(guiGraphics, x, y);
        guiGraphics.drawString(this.font, this.title, x + this.textureWidth / 2 - this.font.width((FormattedText)this.title) / 2, y + 4, 0x404040, false);
        guiGraphics.drawString(this.font, scaleText.getString(), x + 8, y + 36, 0xFFFFFF);
        this.drawPlayerScale(guiGraphics, x, y);
        this.drawScaleOrb(guiGraphics, x, y);
        this.drawButtons(guiGraphics, mouseX, mouseY, x, y);
    }

    private void drawButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int windowX, int windowY) {
        int upX = windowX + 135;
        int upY = windowY + 55;
        int downX = windowX + 135;
        int downY = windowY + 58;
        int buttonWidth = 8;
        int buttonHeight = 4;
        if (mouseX >= upX && mouseX <= upX + buttonWidth && mouseY >= upY && mouseY <= upY + buttonHeight) {
            guiGraphics.blit(this.TEXTURE, upX, upY, 111, 103, buttonWidth, buttonHeight);
        }
        if (mouseX >= downX && mouseX <= downX + buttonWidth && mouseY >= downY && mouseY <= downY + buttonHeight) {
            guiGraphics.blit(this.TEXTURE, downX, downY - 1, 111, 107, buttonWidth, buttonHeight);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int windowX = (this.width - this.textureWidth) / 2;
        int windowY = (this.height - this.textureHeight) / 2;
        int upX = windowX + 135;
        int upY = windowY + 55;
        int downX = windowX + 135;
        int downY = windowY + 59;
        int buttonWidth = 8;
        int buttonHeight = 4;
        if (mouseX >= (double)upX && mouseX <= (double)(upX + buttonWidth) && mouseY >= (double)upY && mouseY <= (double)(upY + buttonHeight) && this.resizeAmount < 127.0f) {
            this.resizeAmount = Upsizing.roundToOneDecimalPlace(this.resizeAmount + 0.0999f);
        }
        if (mouseX >= (double)downX && mouseX <= (double)(downX + buttonWidth) && mouseY >= (double)downY && mouseY <= (double)(downY + buttonHeight) && this.resizeAmount > 0.1f) {
            this.resizeAmount = Upsizing.roundToOneDecimalPlace(this.resizeAmount - 0.10001f);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void drawItem(GuiGraphics guiGraphics, int windowX, int windowY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(windowX + this.textureWidth + 16), (float)(windowY + 64), 0.0f);
        guiGraphics.pose().scale(4.0f, 4.0f, 4.0f);
        guiGraphics.renderFakeItem(new ItemStack((ItemLike)this.item), 0, 0);
        guiGraphics.pose().popPose();
    }

    public void drawInputBox(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        guiGraphics.blit(this.TEXTURE, x, y, 0, 103, 110, 21);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)String.valueOf(this.resizeAmount)), x + 10, y + 7, 0x404040, false);
    }

    public void drawScaleOrb(GuiGraphics guiGraphics, int windowX, int windowY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(windowX + 2), (float)(windowY + 40), 0.0f);
        guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
        guiGraphics.renderFakeItem(new ItemStack((ItemLike)Upsizing.ORB_OF_SCALE.get()), 0, 0);
        guiGraphics.pose().popPose();
    }

    public void drawPlayerScale(GuiGraphics guiGraphics, int windowX, int windowY) {
        String scale = String.valueOf(Upsizing.roundToOneDecimalPlace(ScaleTypes.BASE.getScaleData((Entity)Minecraft.getInstance().player).getTargetScale()));
        guiGraphics.drawString(this.font, scale, windowX + 124 - this.font.width(scale), windowY + 84, 0x404040, false);
    }

    @Nullable
    public Music getBackgroundMusic() {
        return Musics.CREATIVE;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ResizerConfigSyncPayload(this.resizeAmount, this.hand == InteractionHand.MAIN_HAND));
        Minecraft.getInstance().player.getItemInHand(this.hand).set((DataComponentType)ModItemComponents.RESIZER_COMPONENT.get(), (Object)new ResizerAmountComponent(this.resizeAmount));
        super.onClose();
    }
}

