/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.scale;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.juyoh.scale.Config;
import net.juyoh.scale.item.ResizerItem;
import net.juyoh.scale.item.component.ModItemComponents;
import net.juyoh.scale.network.ResizerConfigHandler;
import net.juyoh.scale.network.ResizerConfigSyncPayload;
import net.juyoh.scale.recipe.ModRecipes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="upsizing")
public class Upsizing {
    public static final String MODID = "upsizing";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"upsizing");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"upsizing");
    public static final DeferredItem<Item> RESIZER = ITEMS.registerItem("resizer", ResizerItem::new, new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    public static final DeferredItem<Item> ORB_OF_SCALE = ITEMS.registerSimpleItem("orb_of_scale", new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    public static FontHelper.Palette goldPalette = FontHelper.Palette.STANDARD_CREATE;
    public static FontHelper.Palette greyPalette = FontHelper.Palette.GRAY_AND_WHITE;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> UPSIZING_TAB = CREATIVE_MODE_TABS.register("upsizing", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.upsizing")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((Item)RESIZER.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)RESIZER.get());
        output.accept((ItemLike)ORB_OF_SCALE.get());
    }).build());

    public Upsizing(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModItemComponents.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static Component joinComponents(List<Component> components) {
        MutableComponent component = MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(""));
        for (Component component1 : components) {
            component.append(component1);
        }
        return component;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void stretchItem(ItemEntity entity, Item output) {
        Level world = entity.level();
        entity.setItem(new ItemStack((ItemLike)output, entity.getItem().getCount()));
        world.playSound((Entity)entity, entity.blockPosition(), SoundEvents.SLIME_JUMP_SMALL, SoundSource.MASTER, 1.0f, 1.0f);
        RandomSource random = world.random;
        for (int i = 0; i < 12; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.END_ROD, entity.getX(), entity.getY(), entity.getZ(), random.nextDouble(), random.nextDouble(), random.nextDouble());
        }
    }

    public static float roundToOneDecimalPlace(float in) {
        return (float)(Math.ceil(in * 10.0f) / 10.0);
    }

    @EventBusSubscriber(modid="upsizing", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerPayloads(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToServer(ResizerConfigSyncPayload.TYPE, ResizerConfigSyncPayload.STREAM_CODEC, (IPayloadHandler)new ResizerConfigHandler());
        }
    }

    @EventBusSubscriber(modid="upsizing", bus=EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class ServerModEvents {
        @SubscribeEvent
        public static void registerPayloads(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToServer(ResizerConfigSyncPayload.TYPE, ResizerConfigSyncPayload.STREAM_CODEC, (IPayloadHandler)new ResizerConfigHandler());
        }
    }
}

