/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.client;

import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.TabNameUpdater;
import de.sarocesch.saroscreativetab.data.CustomTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ClientTabManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ClientTabManager instance;
    private final Map<String, CustomTab> tabs = new LinkedHashMap<String, CustomTab>();
    private boolean needsRefresh = false;

    private ClientTabManager() {
    }

    public static ClientTabManager getInstance() {
        if (instance == null) {
            instance = new ClientTabManager();
        }
        return instance;
    }

    public void updateTabs(List<CustomTab> newTabs) {
        this.tabs.clear();
        for (CustomTab tab : newTabs) {
            this.tabs.put(tab.getId(), tab);
        }
        this.needsRefresh = true;
        LOGGER.info("Updated client tabs: {} tabs received", (Object)this.tabs.size());
        TabNameUpdater.updateTabNames();
    }

    public Collection<CustomTab> getAllTabs() {
        return new ArrayList<CustomTab>(this.tabs.values());
    }

    public CustomTab getTab(String id) {
        return this.tabs.get(id);
    }

    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void markRefreshed() {
        this.needsRefresh = false;
    }

    public void clear() {
        this.tabs.clear();
        this.needsRefresh = false;
        LOGGER.info("Cleared client tabs");
    }
}

