/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.client;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CreativeTabRefresher {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void refreshCreativeInventory() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        Screen currentScreen = mc.screen;
        if (currentScreen instanceof CreativeModeInventoryScreen) {
            LOGGER.info("Closing creative inventory for refresh...");
            mc.player.closeContainer();
            mc.player.displayClientMessage((Component)Component.literal((String)"Creative tabs updated! Reopen the creative inventory to see changes.").withStyle(style -> style.withColor(0xFFAA00)), false);
        } else {
            LOGGER.info("Creative inventory not open, tabs will be updated when opened");
        }
    }
}

