/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.client;

import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.data.CustomTab;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="saroscreativetab", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TabNameUpdater {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Field displayNameField = null;
    private static boolean fieldAccessFailed = false;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (fieldAccessFailed || displayNameField == null) {
            return;
        }
        TabNameUpdater.updateTabNames();
    }

    public static void updateTabNames() {
        if (fieldAccessFailed || displayNameField == null) {
            return;
        }
        try {
            Collection<CustomTab> customTabs = ClientTabManager.getInstance().getAllTabs();
            ArrayList<CustomTab> tabList = new ArrayList<CustomTab>(customTabs);
            for (int i = 0; i < tabList.size() && i < 10; ++i) {
                CustomTab customTab = (CustomTab)tabList.get(i);
                ResourceLocation tabId = ResourceLocation.fromNamespaceAndPath((String)"saroscreativetab", (String)("custom_tab_" + i));
                CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(tabId);
                if (tab == null) continue;
                MutableComponent newName = Component.literal((String)customTab.getDisplayName());
                displayNameField.set(tab, newName);
                LOGGER.debug("Updated tab {} display name to: {}", (Object)tabId, (Object)customTab.getDisplayName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to update tab names", (Throwable)e);
            fieldAccessFailed = true;
        }
    }

    static {
        try {
            displayNameField = CreativeModeTab.class.getDeclaredField("displayName");
            displayNameField.setAccessible(true);
            LOGGER.info("Successfully accessed CreativeModeTab.displayName field");
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to find displayName field in CreativeModeTab", (Throwable)e);
            fieldAccessFailed = true;
        }
    }
}

