/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.saroscreativetab.config.ModConfig;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.data.TabPermission;
import de.sarocesch.saroscreativetab.manager.TabManager;
import de.sarocesch.saroscreativetab.network.ModNetworking;
import de.sarocesch.saroscreativetab.network.packet.SyncTabsPacket;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomTabCommand {
    private static final SuggestionProvider<CommandSourceStack> TAB_SUGGESTIONS = (context, builder) -> {
        TabManager.getInstance().getTabIds().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> PERMISSION_SUGGESTIONS = (context, builder) -> {
        for (TabPermission permission : TabPermission.values()) {
            builder.suggest(permission.name());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> ITEM_SUGGESTIONS = (context, builder) -> {
        BuiltInRegistries.ITEM.keySet().forEach(itemLoc -> builder.suggest(itemLoc.toString()));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"customtab").then(Commands.literal((String)"create").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"displayName", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"icon", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::createTab)))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).executes(CustomTabCommand::deleteTab)))).then(Commands.literal((String)"list").executes(CustomTabCommand::listTabs))).then(Commands.literal((String)"add").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::addItem))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::removeItem))))).then(Commands.literal((String)"items").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).executes(CustomTabCommand::listItems)))).then(Commands.literal((String)"rename").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(CustomTabCommand::renameTab))))).then(Commands.literal((String)"seticon").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.argument((String)"icon", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::setIcon))))).then(Commands.literal((String)"setpermission").then(Commands.argument((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.argument((String)"permission", (ArgumentType)StringArgumentType.word()).suggests(PERMISSION_SUGGESTIONS).executes(CustomTabCommand::setPermission))))).then(Commands.literal((String)"reload").executes(CustomTabCommand::reload))).then(Commands.literal((String)"help").executes(CustomTabCommand::help)));
    }

    private static int createTab(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getCreateTabPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to create tabs"));
            return 0;
        }
        String id = StringArgumentType.getString(context, (String)"id");
        String displayName = StringArgumentType.getString(context, (String)"displayName");
        ResourceLocation iconItem = ResourceLocationArgument.getId(context, (String)"icon");
        if (TabManager.getInstance().createTab(id, displayName, iconItem)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Created custom tab: " + displayName)).withStyle(style -> style.withColor(65280)), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Please rejoin the world to see the changes!").withStyle(style -> style.withColor(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab with ID '" + id + "' already exists")));
        return 0;
    }

    private static int deleteTab(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getDeleteTabPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to delete tabs"));
            return 0;
        }
        String id = StringArgumentType.getString(context, (String)"id");
        if (TabManager.getInstance().deleteTab(id)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Deleted custom tab: " + id)).withStyle(style -> style.withColor(65280)), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Please rejoin the world to see the changes!").withStyle(style -> style.withColor(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + id + "' not found")));
        return 0;
    }

    private static int listTabs(CommandContext<CommandSourceStack> context) {
        Collection<CustomTab> tabs = TabManager.getInstance().getAllTabs();
        if (tabs.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No custom tabs created"), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Custom Tabs (" + tabs.size() + "):")), false);
        for (CustomTab tab : tabs) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("  - " + tab.getId() + ": \"" + tab.getDisplayName() + "\" (" + tab.getItems().size() + " items, " + tab.getPermission().getDescription() + ")")), false);
        }
        return tabs.size();
    }

    private static int addItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), tab.getPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to modify this tab"));
            return 0;
        }
        ResourceLocation itemLoc = ResourceLocationArgument.getId(context, (String)"item");
        if (TabManager.getInstance().addItemToTab(tabId, itemLoc)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added " + String.valueOf(itemLoc) + " to tab " + tabId)).withStyle(style -> style.withColor(65280)), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Please rejoin the world to see the changes!").withStyle(style -> style.withColor(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        return 0;
    }

    private static int removeItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), tab.getPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to modify this tab"));
            return 0;
        }
        ResourceLocation itemLoc = ResourceLocationArgument.getId(context, (String)"item");
        if (TabManager.getInstance().removeItemFromTab(tabId, itemLoc)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed " + String.valueOf(itemLoc) + " from tab " + tabId)).withStyle(style -> style.withColor(65280)), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Please rejoin the world to see the changes!").withStyle(style -> style.withColor(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        return 0;
    }

    private static int listItems(CommandContext<CommandSourceStack> context) {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (tab.getItems().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Tab '" + tabId + "' has no items")), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Items in tab '" + tabId + "' (" + tab.getItems().size() + "):")), false);
        for (ResourceLocation item : tab.getItems()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("  - " + String.valueOf(item))), false);
        }
        return tab.getItems().size();
    }

    private static int renameTab(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        String newName = StringArgumentType.getString(context, (String)"newName");
        if (TabManager.getInstance().renameTab(tabId, newName)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Renamed tab '" + tabId + "' to '" + newName + "'")), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int setIcon(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        ResourceLocation iconItem = ResourceLocationArgument.getId(context, (String)"icon");
        if (TabManager.getInstance().setTabIcon(tabId, iconItem)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set icon for tab '" + tabId + "' to " + String.valueOf(iconItem))), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int setPermission(CommandContext<CommandSourceStack> context) {
        TabPermission permission;
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        String permissionStr = StringArgumentType.getString(context, (String)"permission");
        try {
            permission = TabPermission.valueOf(permissionStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Invalid permission level. Valid options: EVERYONE, OP_LEVEL_2, OP_LEVEL_3, OP_LEVEL_4"));
            return 0;
        }
        if (TabManager.getInstance().setTabPermission(tabId, permission)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set permission for tab '" + tabId + "' to " + permission.getDescription())), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), TabPermission.OP_LEVEL_4)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have permission to reload"));
            return 0;
        }
        TabManager.getInstance().loadTabs();
        ModConfig.getInstance().loadConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded custom tabs and configuration"), true);
        CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
        return 1;
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"=== Custom Tab Commands ===").withStyle(style -> style.withColor(65535).withBold(Boolean.valueOf(true))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab create <id> <displayName> <icon>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Create a new tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab delete <id>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Delete a tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab list").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - List all tabs").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab add <tabId> <item>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Add item to tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab remove <tabId> <item>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Remove item from tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab items <tabId>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - List items in tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab rename <tabId> <newName>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Rename tab").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab seticon <tabId> <icon>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Set tab icon").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab setpermission <tabId> <permission>").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Set tab permission").withStyle(style -> style.withColor(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/customtab reload").withStyle(style -> style.withColor(0xFFFF00)).append((Component)Component.literal((String)" - Reload tabs and config").withStyle(style -> style.withColor(0xAAAAAA))), false);
        return 1;
    }

    private static boolean hasPermission(CommandSourceStack source, TabPermission permission) {
        if (permission == TabPermission.EVERYONE) {
            return true;
        }
        return source.hasPermission(permission.getRequiredOpLevel());
    }

    private static void syncToAllPlayers(CommandSourceStack source) {
        SyncTabsPacket packet = new SyncTabsPacket(new ArrayList<CustomTab>(TabManager.getInstance().getAllTabs()));
        ModNetworking.sendToAllPlayers(packet);
    }
}

