/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.data.TabPermission;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;

public class ModConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ModConfig instance;
    private TabPermission defaultTabPermission = TabPermission.EVERYONE;
    private TabPermission createTabPermission = TabPermission.OP_LEVEL_2;
    private TabPermission deleteTabPermission = TabPermission.OP_LEVEL_2;
    private TabPermission modifyTabPermission = TabPermission.EVERYONE;
    private boolean enableDebugLogging = false;
    private File configFile;

    private ModConfig() {
    }

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public void initialize(File configDir) {
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        this.configFile = new File(configDir, "saroscreativetabs-config.json");
        this.loadConfig();
        LOGGER.info("ModConfig initialized");
    }

    public void loadConfig() {
        if (this.configFile == null) {
            LOGGER.warn("Config file not initialized");
            return;
        }
        if (!this.configFile.exists()) {
            LOGGER.info("Config file not found, creating default configuration");
            this.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json.has("defaultTabPermission")) {
                this.defaultTabPermission = TabPermission.fromString(json.get("defaultTabPermission").getAsString());
            }
            if (json.has("createTabPermission")) {
                this.createTabPermission = TabPermission.fromString(json.get("createTabPermission").getAsString());
            }
            if (json.has("deleteTabPermission")) {
                this.deleteTabPermission = TabPermission.fromString(json.get("deleteTabPermission").getAsString());
            }
            if (json.has("modifyTabPermission")) {
                this.modifyTabPermission = TabPermission.fromString(json.get("modifyTabPermission").getAsString());
            }
            if (json.has("enableDebugLogging")) {
                this.enableDebugLogging = json.get("enableDebugLogging").getAsBoolean();
            }
            LOGGER.info("Loaded configuration from file");
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration", (Throwable)e);
        }
    }

    public void saveConfig() {
        if (this.configFile == null) {
            LOGGER.warn("Config file not initialized");
            return;
        }
        try {
            JsonObject json = new JsonObject();
            json.addProperty("_comment", "Configuration for Saro's Creative Tab mod");
            json.addProperty("defaultTabPermission", this.defaultTabPermission.name());
            json.addProperty("createTabPermission", this.createTabPermission.name());
            json.addProperty("deleteTabPermission", this.deleteTabPermission.name());
            json.addProperty("modifyTabPermission", this.modifyTabPermission.name());
            json.addProperty("enableDebugLogging", Boolean.valueOf(this.enableDebugLogging));
            JsonObject permissionInfo = new JsonObject();
            permissionInfo.addProperty("EVERYONE", "All players can perform this action");
            permissionInfo.addProperty("OP_LEVEL_2", "Only operators with level 2+ can perform this action");
            permissionInfo.addProperty("OP_LEVEL_3", "Only operators with level 3+ can perform this action");
            permissionInfo.addProperty("OP_LEVEL_4", "Only operators with level 4 can perform this action");
            json.add("_permissionLevels", (JsonElement)permissionInfo);
            try (FileWriter writer = new FileWriter(this.configFile);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
            LOGGER.info("Saved configuration to file");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public TabPermission getDefaultTabPermission() {
        return this.defaultTabPermission;
    }

    public TabPermission getCreateTabPermission() {
        return this.createTabPermission;
    }

    public TabPermission getDeleteTabPermission() {
        return this.deleteTabPermission;
    }

    public TabPermission getModifyTabPermission() {
        return this.modifyTabPermission;
    }

    public boolean isDebugLoggingEnabled() {
        return this.enableDebugLogging;
    }

    public void setDefaultTabPermission(TabPermission permission) {
        this.defaultTabPermission = permission;
        this.saveConfig();
    }

    public void setCreateTabPermission(TabPermission permission) {
        this.createTabPermission = permission;
        this.saveConfig();
    }

    public void setDeleteTabPermission(TabPermission permission) {
        this.deleteTabPermission = permission;
        this.saveConfig();
    }

    public void setModifyTabPermission(TabPermission permission) {
        this.modifyTabPermission = permission;
        this.saveConfig();
    }

    public void setDebugLogging(boolean enabled) {
        this.enableDebugLogging = enabled;
        this.saveConfig();
    }
}

