/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sarocesch.saroscreativetab.data.TabPermission;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomTab {
    private final String id;
    private String displayName;
    private ResourceLocation iconItem;
    private final List<ResourceLocation> items;
    private TabPermission permission;

    public CustomTab(String id, String displayName, ResourceLocation iconItem) {
        this.id = id;
        this.displayName = displayName;
        this.iconItem = iconItem;
        this.items = new ArrayList<ResourceLocation>();
        this.permission = TabPermission.OP_LEVEL_2;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ResourceLocation getIconItem() {
        return this.iconItem;
    }

    public void setIconItem(ResourceLocation iconItem) {
        this.iconItem = iconItem;
    }

    public List<ResourceLocation> getItems() {
        return new ArrayList<ResourceLocation>(this.items);
    }

    public void addItem(ResourceLocation item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    public void removeItem(ResourceLocation item) {
        this.items.remove(item);
    }

    public void clearItems() {
        this.items.clear();
    }

    public TabPermission getPermission() {
        return this.permission;
    }

    public void setPermission(TabPermission permission) {
        this.permission = permission;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", this.id);
        tag.putString("displayName", this.displayName);
        tag.putString("iconItem", this.iconItem.toString());
        tag.putString("permission", this.permission.name());
        ListTag itemsList = new ListTag();
        for (ResourceLocation item : this.items) {
            itemsList.add((Object)StringTag.valueOf((String)item.toString()));
        }
        tag.put("items", (Tag)itemsList);
        return tag;
    }

    public static CustomTab fromNBT(CompoundTag tag) {
        String id = tag.getString("id");
        String displayName = tag.getString("displayName");
        ResourceLocation iconItem = ResourceLocation.tryParse((String)tag.getString("iconItem"));
        if (iconItem == null) {
            iconItem = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone");
        }
        CustomTab customTab = new CustomTab(id, displayName, iconItem);
        if (tag.contains("permission")) {
            try {
                customTab.setPermission(TabPermission.valueOf(tag.getString("permission")));
            }
            catch (IllegalArgumentException e) {
                customTab.setPermission(TabPermission.OP_LEVEL_2);
            }
        }
        if (tag.contains("items")) {
            ListTag itemsList = tag.getList("items", 8);
            for (int i = 0; i < itemsList.size(); ++i) {
                try {
                    ResourceLocation itemLoc = ResourceLocation.tryParse((String)itemsList.getString(i));
                    if (itemLoc == null) continue;
                    customTab.addItem(itemLoc);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return customTab;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("displayName", this.displayName);
        json.addProperty("iconItem", this.iconItem.toString());
        json.addProperty("permission", this.permission.name());
        JsonArray itemsArray = new JsonArray();
        for (ResourceLocation item : this.items) {
            itemsArray.add(item.toString());
        }
        json.add("items", (JsonElement)itemsArray);
        return json;
    }

    public static CustomTab fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String displayName = json.get("displayName").getAsString();
        ResourceLocation iconItem = ResourceLocation.tryParse((String)json.get("iconItem").getAsString());
        if (iconItem == null) {
            iconItem = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone");
        }
        CustomTab customTab = new CustomTab(id, displayName, iconItem);
        if (json.has("permission")) {
            try {
                customTab.setPermission(TabPermission.valueOf(json.get("permission").getAsString()));
            }
            catch (IllegalArgumentException e) {
                customTab.setPermission(TabPermission.OP_LEVEL_2);
            }
        }
        if (json.has("items")) {
            JsonArray itemsArray = json.getAsJsonArray("items");
            for (int i = 0; i < itemsArray.size(); ++i) {
                try {
                    ResourceLocation itemLoc = ResourceLocation.tryParse((String)itemsArray.get(i).getAsString());
                    if (itemLoc == null) continue;
                    customTab.addItem(itemLoc);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return customTab;
    }

    public ItemStack getIconStack() {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(this.iconItem);
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ResourceLocation itemLoc : this.items) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
            if (item == null) continue;
            stacks.add(new ItemStack((ItemLike)item));
        }
        return stacks;
    }

    public String toString() {
        return "CustomTab{id='" + this.id + "', displayName='" + this.displayName + "', items=" + this.items.size() + "}";
    }
}

