/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.data;

import net.minecraft.server.level.ServerPlayer;

public enum TabPermission {
    EVERYONE(0),
    OP_LEVEL_2(2),
    OP_LEVEL_3(3),
    OP_LEVEL_4(4);

    private final int requiredOpLevel;

    private TabPermission(int requiredOpLevel) {
        this.requiredOpLevel = requiredOpLevel;
    }

    public int getRequiredOpLevel() {
        return this.requiredOpLevel;
    }

    public boolean hasPermission(ServerPlayer player) {
        if (this == EVERYONE) {
            return true;
        }
        return player.hasPermissions(this.requiredOpLevel);
    }

    public String getDescription() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Everyone";
            case 1 -> "Operators (Level 2+)";
            case 2 -> "Operators (Level 3+)";
            case 3 -> "Operators (Level 4)";
        };
    }

    public static TabPermission fromString(String str) {
        try {
            return TabPermission.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return OP_LEVEL_2;
        }
    }
}

