/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.data.TabPermission;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class TabManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TabManager instance;
    private final Map<String, CustomTab> tabs = new LinkedHashMap<String, CustomTab>();
    private File dataFile;

    private TabManager() {
    }

    public static TabManager getInstance() {
        if (instance == null) {
            instance = new TabManager();
        }
        return instance;
    }

    public void initialize(MinecraftServer server) {
        File worldDir = server.getLevel(Level.OVERWORLD).getServer().getServerDirectory().toFile();
        File dataDir = new File(worldDir, "data");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        this.dataFile = new File(dataDir, "saroscreativetabs.json");
        this.loadTabs();
        LOGGER.info("TabManager initialized with {} custom tabs from {}", (Object)this.tabs.size(), (Object)this.dataFile.getAbsolutePath());
    }

    public boolean createTab(String id, String displayName, ResourceLocation iconItem) {
        if (this.tabs.containsKey(id)) {
            return false;
        }
        CustomTab tab = new CustomTab(id, displayName, iconItem);
        this.tabs.put(id, tab);
        this.saveTabs();
        LOGGER.info("Created custom tab: {}", (Object)id);
        return true;
    }

    public boolean deleteTab(String id) {
        if (!this.tabs.containsKey(id)) {
            return false;
        }
        this.tabs.remove(id);
        this.saveTabs();
        LOGGER.info("Deleted custom tab: {}", (Object)id);
        return true;
    }

    public CustomTab getTab(String id) {
        return this.tabs.get(id);
    }

    public Collection<CustomTab> getAllTabs() {
        return new ArrayList<CustomTab>(this.tabs.values());
    }

    public Set<String> getTabIds() {
        return new HashSet<String>(this.tabs.keySet());
    }

    public boolean hasTab(String id) {
        return this.tabs.containsKey(id);
    }

    public boolean renameTab(String id, String newDisplayName) {
        CustomTab tab = this.tabs.get(id);
        if (tab == null) {
            return false;
        }
        tab.setDisplayName(newDisplayName);
        this.saveTabs();
        LOGGER.info("Renamed tab {} to '{}'", (Object)id, (Object)newDisplayName);
        return true;
    }

    public boolean setTabIcon(String id, ResourceLocation iconItem) {
        CustomTab tab = this.tabs.get(id);
        if (tab == null) {
            return false;
        }
        tab.setIconItem(iconItem);
        this.saveTabs();
        LOGGER.info("Set icon for tab {} to {}", (Object)id, (Object)iconItem);
        return true;
    }

    public boolean addItemToTab(String tabId, ResourceLocation item) {
        CustomTab tab = this.tabs.get(tabId);
        if (tab == null) {
            return false;
        }
        tab.addItem(item);
        this.saveTabs();
        LOGGER.info("Added item {} to tab {}", (Object)item, (Object)tabId);
        return true;
    }

    public boolean removeItemFromTab(String tabId, ResourceLocation item) {
        CustomTab tab = this.tabs.get(tabId);
        if (tab == null) {
            return false;
        }
        tab.removeItem(item);
        this.saveTabs();
        LOGGER.info("Removed item {} from tab {}", (Object)item, (Object)tabId);
        return true;
    }

    public boolean clearTabItems(String tabId) {
        CustomTab tab = this.tabs.get(tabId);
        if (tab == null) {
            return false;
        }
        tab.clearItems();
        this.saveTabs();
        LOGGER.info("Cleared all items from tab {}", (Object)tabId);
        return true;
    }

    public boolean setTabPermission(String tabId, TabPermission permission) {
        CustomTab tab = this.tabs.get(tabId);
        if (tab == null) {
            return false;
        }
        tab.setPermission(permission);
        this.saveTabs();
        LOGGER.info("Set permission for tab {} to {}", (Object)tabId, (Object)permission);
        return true;
    }

    public void saveTabs() {
        if (this.dataFile == null) {
            LOGGER.warn("Cannot save tabs - data file not initialized");
            return;
        }
        try {
            JsonObject root = new JsonObject();
            root.addProperty("version", (Number)1);
            JsonArray tabsArray = new JsonArray();
            for (CustomTab tab : this.tabs.values()) {
                tabsArray.add((JsonElement)tab.toJson());
            }
            root.add("tabs", (JsonElement)tabsArray);
            try (FileWriter writer = new FileWriter(this.dataFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            LOGGER.info("Saved {} custom tabs to file", (Object)this.tabs.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save custom tabs", (Throwable)e);
        }
    }

    public void loadTabs() {
        if (this.dataFile == null || !this.dataFile.exists()) {
            LOGGER.info("No custom tabs file found, starting fresh");
            return;
        }
        try (FileReader reader = new FileReader(this.dataFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root.has("tabs")) {
                JsonArray tabsArray = root.getAsJsonArray("tabs");
                this.tabs.clear();
                for (int i = 0; i < tabsArray.size(); ++i) {
                    try {
                        JsonObject tabJson = tabsArray.get(i).getAsJsonObject();
                        CustomTab tab = CustomTab.fromJson(tabJson);
                        this.tabs.put(tab.getId(), tab);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load custom tab at index {}", (Object)i, (Object)e);
                    }
                }
                LOGGER.info("Loaded {} custom tabs from file", (Object)this.tabs.size());
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load custom tabs", (Throwable)e);
        }
    }

    public void clearAllTabs() {
        this.tabs.clear();
        this.saveTabs();
        LOGGER.info("Cleared all custom tabs");
    }
}

