/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.mixin;

import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.manager.TabManager;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeTab.class})
public class CreativeModeTabMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"getDisplayName"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getDynamicDisplayName(CallbackInfoReturnable<Component> cir) {
        String path;
        CreativeModeTab tab = (CreativeModeTab)this;
        ResourceLocation tabId = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)tab);
        LOGGER.info("CreativeModeTabMixin.getDisplayName called for tab: {}", (Object)tabId);
        if (tabId != null && tabId.getNamespace().equals("saroscreativetab") && (path = tabId.getPath()).startsWith("custom_tab_")) {
            try {
                int index = Integer.parseInt(path.substring("custom_tab_".length()));
                CustomTab customTab = CreativeModeTabMixin.getCustomTabForIndex(index);
                LOGGER.info("Got custom tab for index {}: {}", (Object)index, (Object)customTab);
                if (customTab != null) {
                    MutableComponent newName = Component.literal((String)customTab.getDisplayName());
                    LOGGER.info("Returning custom display name: {}", (Object)customTab.getDisplayName());
                    cir.setReturnValue((Object)newName);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse tab index from: {}", (Object)path, (Object)e);
            }
        }
    }

    private static CustomTab getCustomTabForIndex(int index) {
        ArrayList<CustomTab> tabList;
        Collection<CustomTab> customTabs = TabManager.getInstance().getAllTabs();
        if (customTabs.isEmpty()) {
            customTabs = ClientTabManager.getInstance().getAllTabs();
        }
        if (index < (tabList = new ArrayList<CustomTab>(customTabs)).size()) {
            return (CustomTab)tabList.get(index);
        }
        return null;
    }
}

