/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.network.packet;

import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.client.CreativeTabRefresher;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.integration.DynamicTabRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.slf4j.Logger;

public class SyncTabsPacket {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<CustomTab> tabs;

    public SyncTabsPacket(List<CustomTab> tabs) {
        this.tabs = tabs;
    }

    public static void encode(SyncTabsPacket packet, FriendlyByteBuf buffer) {
        ListTag tabsList = new ListTag();
        for (CustomTab tab : packet.tabs) {
            tabsList.add((Object)tab.toNBT());
        }
        CompoundTag compound = new CompoundTag();
        compound.put("tabs", (Tag)tabsList);
        buffer.writeNbt((Tag)compound);
    }

    public static SyncTabsPacket decode(FriendlyByteBuf buffer) {
        CompoundTag compound = buffer.readNbt();
        ArrayList<CustomTab> tabs = new ArrayList<CustomTab>();
        if (compound != null && compound.contains("tabs")) {
            ListTag tabsList = compound.getList("tabs", 10);
            for (int i = 0; i < tabsList.size(); ++i) {
                try {
                    CompoundTag tabTag = tabsList.getCompound(i);
                    CustomTab tab = CustomTab.fromNBT(tabTag);
                    tabs.add(tab);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to decode custom tab at index {}", (Object)i, (Object)e);
                }
            }
        }
        return new SyncTabsPacket(tabs);
    }

    public static void handle(SyncTabsPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ClientTabManager.getInstance().updateTabs(packet.tabs);
            LOGGER.info("Received {} custom tabs from server", (Object)packet.tabs.size());
            DynamicTabRegistry.refreshTabs();
            CreativeTabRefresher.refreshCreativeInventory();
        });
        context.setPacketHandled(true);
    }

    public List<CustomTab> getTabs() {
        return this.tabs;
    }
}

