/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.command.CustomTabCommand;
import de.sarocesch.saroscreativetab.config.ModConfig;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.integration.DynamicTabRegistry;
import de.sarocesch.saroscreativetab.manager.TabManager;
import de.sarocesch.saroscreativetab.network.ModNetworking;
import de.sarocesch.saroscreativetab.network.packet.SyncTabsPacket;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="saroscreativetab")
public class SarosCreativeTab {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "saroscreativetab";

    public SarosCreativeTab() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        DynamicTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("Saro's Creative Tab - Dynamic Tab Management System initialized");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModNetworking.register();
            LOGGER.info("Network packets registered");
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting - initializing custom tab system");
        File configDir = new File(event.getServer().m_6237_(), "config");
        ModConfig.getInstance().initialize(configDir);
        TabManager.getInstance().initialize(event.getServer());
        LOGGER.info("Custom tab system initialized with {} tabs", (Object)TabManager.getInstance().getAllTabs().size());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping - saving custom tabs");
        TabManager.getInstance().saveTabs();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CustomTabCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("Custom tab commands registered");
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SyncTabsPacket packet = new SyncTabsPacket(new ArrayList<CustomTab>(TabManager.getInstance().getAllTabs()));
            ModNetworking.sendToPlayer(packet, player2);
            LOGGER.info("Synced {} custom tabs to player {}", (Object)TabManager.getInstance().getAllTabs().size(), (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            ClientTabManager.getInstance().clear();
        }
    }
}

