/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.saroscreativetab.config.ModConfig;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.data.TabPermission;
import de.sarocesch.saroscreativetab.manager.TabManager;
import de.sarocesch.saroscreativetab.network.ModNetworking;
import de.sarocesch.saroscreativetab.network.packet.SyncTabsPacket;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomTabCommand {
    private static final SuggestionProvider<CommandSourceStack> TAB_SUGGESTIONS = (context, builder) -> {
        TabManager.getInstance().getTabIds().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> PERMISSION_SUGGESTIONS = (context, builder) -> {
        for (TabPermission permission : TabPermission.values()) {
            builder.suggest(permission.name());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> ITEM_SUGGESTIONS = (context, builder) -> {
        BuiltInRegistries.f_257033_.m_6566_().forEach(itemLoc -> builder.suggest(itemLoc.toString()));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"customtab").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"displayName", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"icon", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::createTab)))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).executes(CustomTabCommand::deleteTab)))).then(Commands.m_82127_((String)"list").executes(CustomTabCommand::listTabs))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.m_82129_((String)"item", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::addItem))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.m_82129_((String)"item", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::removeItem))))).then(Commands.m_82127_((String)"items").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).executes(CustomTabCommand::listItems)))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.m_82129_((String)"newName", (ArgumentType)StringArgumentType.string()).executes(CustomTabCommand::renameTab))))).then(Commands.m_82127_((String)"seticon").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.m_82129_((String)"icon", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ITEM_SUGGESTIONS).executes(CustomTabCommand::setIcon))))).then(Commands.m_82127_((String)"setpermission").then(Commands.m_82129_((String)"tabId", (ArgumentType)StringArgumentType.word()).suggests(TAB_SUGGESTIONS).then(Commands.m_82129_((String)"permission", (ArgumentType)StringArgumentType.word()).suggests(PERMISSION_SUGGESTIONS).executes(CustomTabCommand::setPermission))))).then(Commands.m_82127_((String)"reload").executes(CustomTabCommand::reload))).then(Commands.m_82127_((String)"help").executes(CustomTabCommand::help)));
    }

    private static int createTab(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getCreateTabPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to create tabs"));
            return 0;
        }
        String id = StringArgumentType.getString(context, (String)"id");
        String displayName = StringArgumentType.getString(context, (String)"displayName");
        ResourceLocation iconItem = ResourceLocationArgument.m_107011_(context, (String)"icon");
        if (TabManager.getInstance().createTab(id, displayName, iconItem)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Created custom tab: " + displayName)).m_130938_(style -> style.m_178520_(65280)), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Please rejoin the world to see the changes!").m_130938_(style -> style.m_178520_(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab with ID '" + id + "' already exists")));
        return 0;
    }

    private static int deleteTab(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getDeleteTabPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to delete tabs"));
            return 0;
        }
        String id = StringArgumentType.getString(context, (String)"id");
        if (TabManager.getInstance().deleteTab(id)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Deleted custom tab: " + id)).m_130938_(style -> style.m_178520_(65280)), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Please rejoin the world to see the changes!").m_130938_(style -> style.m_178520_(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + id + "' not found")));
        return 0;
    }

    private static int listTabs(CommandContext<CommandSourceStack> context) {
        Collection<CustomTab> tabs = TabManager.getInstance().getAllTabs();
        if (tabs.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No custom tabs created"), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Custom Tabs (" + tabs.size() + "):")), false);
        for (CustomTab tab : tabs) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  - " + tab.getId() + ": \"" + tab.getDisplayName() + "\" (" + tab.getItems().size() + " items, " + tab.getPermission().getDescription() + ")")), false);
        }
        return tabs.size();
    }

    private static int addItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), tab.getPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to modify this tab"));
            return 0;
        }
        ResourceLocation itemLoc = ResourceLocationArgument.m_107011_(context, (String)"item");
        if (TabManager.getInstance().addItemToTab(tabId, itemLoc)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added " + String.valueOf(itemLoc) + " to tab " + tabId)).m_130938_(style -> style.m_178520_(65280)), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Please rejoin the world to see the changes!").m_130938_(style -> style.m_178520_(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        return 0;
    }

    private static int removeItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), tab.getPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to modify this tab"));
            return 0;
        }
        ResourceLocation itemLoc = ResourceLocationArgument.m_107011_(context, (String)"item");
        if (TabManager.getInstance().removeItemFromTab(tabId, itemLoc)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed " + String.valueOf(itemLoc) + " from tab " + tabId)).m_130938_(style -> style.m_178520_(65280)), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Please rejoin the world to see the changes!").m_130938_(style -> style.m_178520_(0xFFAA00)), false);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        return 0;
    }

    private static int listItems(CommandContext<CommandSourceStack> context) {
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        CustomTab tab = TabManager.getInstance().getTab(tabId);
        if (tab == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
            return 0;
        }
        if (tab.getItems().isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Tab '" + tabId + "' has no items")), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Items in tab '" + tabId + "' (" + tab.getItems().size() + "):")), false);
        for (ResourceLocation item : tab.getItems()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  - " + String.valueOf(item))), false);
        }
        return tab.getItems().size();
    }

    private static int renameTab(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        String newName = StringArgumentType.getString(context, (String)"newName");
        if (TabManager.getInstance().renameTab(tabId, newName)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Renamed tab '" + tabId + "' to '" + newName + "'")), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int setIcon(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        ResourceLocation iconItem = ResourceLocationArgument.m_107011_(context, (String)"icon");
        if (TabManager.getInstance().setTabIcon(tabId, iconItem)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set icon for tab '" + tabId + "' to " + String.valueOf(iconItem))), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int setPermission(CommandContext<CommandSourceStack> context) {
        TabPermission permission;
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), ModConfig.getInstance().getModifyTabPermission())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to modify tabs"));
            return 0;
        }
        String tabId = StringArgumentType.getString(context, (String)"tabId");
        String permissionStr = StringArgumentType.getString(context, (String)"permission");
        try {
            permission = TabPermission.valueOf(permissionStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid permission level. Valid options: EVERYONE, OP_LEVEL_2, OP_LEVEL_3, OP_LEVEL_4"));
            return 0;
        }
        if (TabManager.getInstance().setTabPermission(tabId, permission)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set permission for tab '" + tabId + "' to " + permission.getDescription())), true);
            CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab '" + tabId + "' not found")));
        return 0;
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        if (!CustomTabCommand.hasPermission((CommandSourceStack)context.getSource(), TabPermission.OP_LEVEL_4)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You don't have permission to reload"));
            return 0;
        }
        TabManager.getInstance().loadTabs();
        ModConfig.getInstance().loadConfig();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Reloaded custom tabs and configuration"), true);
        CustomTabCommand.syncToAllPlayers((CommandSourceStack)context.getSource());
        return 1;
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Custom Tab Commands ===").m_130938_(style -> style.m_178520_(65535).m_131136_(Boolean.valueOf(true))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab create <id> <displayName> <icon>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Create a new tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab delete <id>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Delete a tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab list").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - List all tabs").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab add <tabId> <item>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Add item to tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab remove <tabId> <item>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Remove item from tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab items <tabId>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - List items in tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab rename <tabId> <newName>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Rename tab").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab seticon <tabId> <icon>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Set tab icon").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab setpermission <tabId> <permission>").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Set tab permission").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/customtab reload").m_130938_(style -> style.m_178520_(0xFFFF00)).m_7220_((Component)Component.m_237113_((String)" - Reload tabs and config").m_130938_(style -> style.m_178520_(0xAAAAAA))), false);
        return 1;
    }

    private static boolean hasPermission(CommandSourceStack source, TabPermission permission) {
        if (permission == TabPermission.EVERYONE) {
            return true;
        }
        return source.m_6761_(permission.getRequiredOpLevel());
    }

    private static void syncToAllPlayers(CommandSourceStack source) {
        SyncTabsPacket packet = new SyncTabsPacket(new ArrayList<CustomTab>(TabManager.getInstance().getAllTabs()));
        ModNetworking.sendToAllPlayers(packet);
    }
}

