/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.integration;

import com.mojang.logging.LogUtils;
import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.manager.TabManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="saroscreativetab", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicTabRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"saroscreativetab");
    private static final List<RegistryObject<CreativeModeTab>> TAB_POOL = new ArrayList<RegistryObject<CreativeModeTab>>();
    private static final int MAX_TABS = 10;
    private static final Map<Integer, String> tabIndexToId = new HashMap<Integer, String>();

    private static CustomTab getCustomTabForIndex(int index) {
        ArrayList<CustomTab> tabList;
        Collection<CustomTab> customTabs = TabManager.getInstance().getAllTabs();
        if (customTabs.isEmpty()) {
            customTabs = ClientTabManager.getInstance().getAllTabs();
        }
        if (index < (tabList = new ArrayList<CustomTab>(customTabs)).size()) {
            return (CustomTab)tabList.get(index);
        }
        return null;
    }

    private static void populateTabContents(int tabIndex, CreativeModeTab.Output output) {
        CustomTab customTab = DynamicTabRegistry.getCustomTabForIndex(tabIndex);
        if (customTab != null) {
            List<ItemStack> items = customTab.getItemStacks();
            if (items.isEmpty()) {
                output.m_246342_(new ItemStack((ItemLike)Items.f_42127_));
            } else {
                for (ItemStack stack : items) {
                    output.m_246342_(stack);
                }
            }
            LOGGER.debug("Populated tab {} with {} items", (Object)customTab.getDisplayName(), (Object)items.size());
        }
    }

    public static void refreshTabs() {
        tabIndexToId.clear();
        Collection<CustomTab> customTabs = TabManager.getInstance().getAllTabs();
        if (customTabs.isEmpty()) {
            customTabs = ClientTabManager.getInstance().getAllTabs();
        }
        ArrayList<CustomTab> tabList = new ArrayList<CustomTab>(customTabs);
        for (int i = 0; i < Math.min(tabList.size(), 10); ++i) {
            tabIndexToId.put(i, ((CustomTab)tabList.get(i)).getId());
        }
        LOGGER.info("Refreshed {} custom tabs", (Object)tabIndexToId.size());
    }

    public static int getActiveTabCount() {
        return Math.min(TabManager.getInstance().getAllTabs().size(), 10);
    }

    public static int getMaxTabs() {
        return 10;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            int index = i;
            RegistryObject tab = CREATIVE_MODE_TABS.register("custom_tab_" + i, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)("Custom Tab " + index))).m_257737_(() -> {
                CustomTab customTab = DynamicTabRegistry.getCustomTabForIndex(index);
                if (customTab != null) {
                    return customTab.getIconStack();
                }
                return new ItemStack((ItemLike)Items.f_42127_);
            }).m_257501_((parameters, output) -> DynamicTabRegistry.populateTabContents(index, output)).withTabsImage(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/creative_inventory/tabs.png")).m_257652_());
            TAB_POOL.add((RegistryObject<CreativeModeTab>)tab);
        }
    }
}

