/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroscreativetab.mixin;

import de.sarocesch.saroscreativetab.client.ClientTabManager;
import de.sarocesch.saroscreativetab.data.CustomTab;
import de.sarocesch.saroscreativetab.manager.TabManager;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeTab.class})
public class CreativeModeTabMixin {
    @Shadow
    @Final
    @Mutable
    private Component displayName;

    @Inject(method={"getDisplayName"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDynamicDisplayName(CallbackInfoReturnable<Component> cir) {
        String path;
        CreativeModeTab tab = (CreativeModeTab)this;
        ResourceLocation tabId = BuiltInRegistries.f_279662_.m_7981_((Object)tab);
        if (tabId != null && tabId.m_135827_().equals("saroscreativetab") && (path = tabId.m_135815_()).startsWith("custom_tab_")) {
            try {
                int index = Integer.parseInt(path.substring("custom_tab_".length()));
                CustomTab customTab = CreativeModeTabMixin.getCustomTabForIndex(index);
                if (customTab != null) {
                    cir.setReturnValue((Object)Component.m_237113_((String)customTab.getDisplayName()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static CustomTab getCustomTabForIndex(int index) {
        ArrayList<CustomTab> tabList;
        Collection<CustomTab> customTabs = TabManager.getInstance().getAllTabs();
        if (customTabs.isEmpty()) {
            customTabs = ClientTabManager.getInstance().getAllTabs();
        }
        if (index < (tabList = new ArrayList<CustomTab>(customTabs)).size()) {
            return (CustomTab)tabList.get(index);
        }
        return null;
    }
}

