/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks;

import com.mojang.logging.LogUtils;
import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.item.TunerItem;
import de.sarocesch.pakourblocks.network.NetworkHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="saroparkourblocks")
public class ParkourBlocksMod {
    public static final String MODID = "saroparkourblocks";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"saroparkourblocks");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"saroparkourblocks");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"saroparkourblocks");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"saroparkourblocks");
    public static final RegistryObject<Block> PARKOUR_BLOCK = BLOCKS.register("parkour_block", () -> new ParkourBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(2.0f, 6.0f)));
    public static final RegistryObject<Item> PARKOUR_BLOCK_ITEM = ITEMS.register("parkour_block", () -> new BlockItem((Block)PARKOUR_BLOCK.get(), new Item.Properties()){

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.saroparkourblocks.parkour_block"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.saroparkourblocks.parkour_block_tuner"));
            super.m_7373_(stack, level, tooltip, flag);
        }
    });
    public static final RegistryObject<Item> TUNER_ITEM = ITEMS.register("tuner", () -> new TunerItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<CreativeModeTab> PARKOUR_TAB = CREATIVE_MODE_TABS.register("parkour_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256788_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.saroparkourblocks.parkour_tab")).m_257737_(() -> ((Item)PARKOUR_BLOCK_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)PARKOUR_BLOCK_ITEM.get());
        output.m_246326_((ItemLike)TUNER_ITEM.get());
    }).m_257652_());
    public static final RegistryObject<BlockEntityType<ParkourBlockEntity>> PARKOUR_BLOCK_ENTITY = BLOCK_ENTITIES.register("parkour_block", () -> BlockEntityType.Builder.m_155273_(ParkourBlockEntity::new, (Block[])new Block[]{(Block)PARKOUR_BLOCK.get()}).m_58966_(null));

    public ParkourBlocksMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (ModConfig.debugMode) {
            LOGGER.info("ParkourBlocks: Common setup initialized");
            LOGGER.info("ParkourBlocks: Registered blocks - {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        event.enqueueWork(() -> NetworkHandler.init());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(PARKOUR_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (ModConfig.debugMode) {
            LOGGER.info("ParkourBlocks: Server starting");
        }
    }

    @Mod.EventBusSubscriber(modid="saroparkourblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (ModConfig.debugMode) {
                LOGGER.info("ParkourBlocks: Client setup initialized");
                LOGGER.info("ParkourBlocks: Minecraft username - {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="saroparkourblocks", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        private static final Logger LOGGER = LogUtils.getLogger();

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity().m_9236_() instanceof ServerLevel) {
                if (ModConfig.debugMode) {
                    LOGGER.info("ParkourBlocks: Player respawned, ensuring disguises are restored");
                }
                Player player = event.getEntity();
                ServerLevel level = (ServerLevel)player.m_9236_();
                level.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                    BlockPos playerPos = player.m_20183_();
                    int scanRadius = 8;
                    if (ModConfig.debugMode) {
                        LOGGER.info("Scanning for ParkourBlocks around player at {} with radius {}", (Object)playerPos, (Object)scanRadius);
                    }
                    LevelChunk chunk = level.m_46745_(playerPos);
                    for (BlockEntity blockEntity : chunk.m_62954_().values()) {
                        ParkourBlockEntity parkourBlockEntity;
                        if (!(blockEntity instanceof ParkourBlockEntity) || (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState() == null) continue;
                        if (ModConfig.debugMode) {
                            LOGGER.info("Restoring disguise for ParkourBlock at {}", (Object)blockEntity.m_58899_());
                        }
                        parkourBlockEntity.updateBlockStateWithDisguise();
                    }
                    if (ModConfig.debugMode) {
                        LOGGER.info("ParkourBlocks: Finished restoring disguises around player");
                    }
                }));
            }
        }
    }
}

