/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.block;

import de.sarocesch.pakourblocks.ParkourBlocksMod;
import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.movement.MovementSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParkourBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParkourBlockEntity.class);
    private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    private MovementSequence movementSequence = new MovementSequence();
    private boolean movementEnabled = false;
    private boolean destroyBlocks = true;
    private boolean isBlocked = false;
    private boolean isPaused = false;
    private int movementSpeed = 10;
    private BlockPos originalPos = null;
    private BlockState disguiseState = null;

    public ParkourBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ParkourBlocksMod.PARKOUR_BLOCK_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.disguiseState != null) {
            if (ModConfig.debugMode) {
                LOGGER.info("onLoad: Restoring disguise state for ParkourBlockEntity at {} (isClientSide: {})", (Object)this.m_58899_(), this.f_58857_ != null ? Boolean.valueOf(this.f_58857_.f_46443_) : "null");
            }
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.updateBlockStateWithDisguise();
            }
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public void setEffects(List<MobEffectInstance> effects) {
        this.effects = new ArrayList<MobEffectInstance>(effects);
        if (ModConfig.debugMode) {
            LOGGER.info("Set {} effects on ParkourBlockEntity at {}", (Object)effects.size(), (Object)this.m_58899_());
            for (MobEffectInstance effect : effects) {
                LOGGER.info("  - Effect: {}, Level: {}, Duration: {} ticks", new Object[]{effect.m_19544_().m_19481_(), effect.m_19564_(), effect.m_19557_()});
            }
        }
        this.m_6596_();
    }

    public MovementSequence getMovementSequence() {
        return this.movementSequence;
    }

    public void setMovementSequence(MovementSequence sequence) {
        this.movementSequence = sequence;
        if (ModConfig.debugMode) {
            LOGGER.info("Set movement sequence with {} steps on ParkourBlockEntity at {}", (Object)sequence.getSteps().size(), (Object)this.m_58899_());
        }
        this.m_6596_();
    }

    public boolean isMovementEnabled() {
        return this.movementEnabled;
    }

    public void setMovementEnabled(boolean enabled) {
        this.movementEnabled = enabled;
        if (ModConfig.debugMode) {
            LOGGER.info("Movement {} for ParkourBlockEntity at {}", (Object)(enabled ? "enabled" : "disabled"), (Object)this.m_58899_());
        }
        this.m_6596_();
    }

    public boolean canDestroyBlocks() {
        return this.destroyBlocks;
    }

    public void setDestroyBlocks(boolean destroyBlocks) {
        this.destroyBlocks = destroyBlocks;
        if (ModConfig.debugMode) {
            LOGGER.info("Destroy blocks {} for ParkourBlockEntity at {}", (Object)(destroyBlocks ? "enabled" : "disabled"), (Object)this.m_58899_());
        }
        this.m_6596_();
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
        this.m_6596_();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void setPaused(boolean paused) {
        this.isPaused = paused;
        if (ModConfig.debugMode) {
            LOGGER.info("ParkourBlockEntity at {} is {}", (Object)this.m_58899_(), (Object)(paused ? "paused" : "unpaused"));
        }
        this.m_6596_();
    }

    public int getMovementSpeed() {
        return this.movementSpeed;
    }

    public void setMovementSpeed(int speed) {
        this.movementSpeed = speed;
        this.m_6596_();
    }

    public BlockPos getOriginalPos() {
        if (this.originalPos == null) {
            this.originalPos = this.m_58899_().m_7949_();
        }
        return this.originalPos;
    }

    public void setOriginalPos(BlockPos pos) {
        this.originalPos = pos.m_7949_();
        if (ModConfig.debugMode) {
            LOGGER.info("Set original position to {} for ParkourBlockEntity at {}", (Object)this.originalPos, (Object)this.m_58899_());
        }
        this.m_6596_();
    }

    public BlockState getDisguiseState() {
        return this.disguiseState;
    }

    public void setDisguiseState(BlockState state) {
        this.disguiseState = state;
        if (ModConfig.debugMode) {
            LOGGER.info("Set disguise state to {} for ParkourBlockEntity at {}", (Object)(state != null ? state.m_60734_().m_49954_().getString() : "null"), (Object)this.m_58899_());
            if (state != null && !state.m_61147_().isEmpty()) {
                StringBuilder propertiesStr = new StringBuilder();
                for (Property property : state.m_61147_()) {
                    propertiesStr.append(property.m_61708_()).append("=").append(this.getPropertyValueAsString(state, property)).append(", ");
                }
                LOGGER.info("Disguise state properties: {}", (Object)propertiesStr.toString());
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && state != null) {
            this.updateBlockStateWithDisguise();
        }
    }

    public void updateBlockStateWithDisguise() {
        if (this.f_58857_ == null || this.disguiseState == null) {
            return;
        }
        BlockState currentState = this.f_58857_.m_8055_(this.m_58899_());
        if (!(currentState.m_60734_() instanceof ParkourBlock)) {
            if (ModConfig.debugMode) {
                LOGGER.warn("Block at {} is not a ParkourBlock, cannot update disguise", (Object)this.m_58899_());
            }
            return;
        }
        ResourceLocation disguiseBlockId = BuiltInRegistries.f_256975_.m_7981_((Object)this.disguiseState.m_60734_());
        String blockIdString = disguiseBlockId.toString();
        ParkourBlock.DisguiseType disguiseType = ParkourBlock.DisguiseType.fromBlockId(blockIdString);
        BlockState newState = (BlockState)((BlockState)currentState.m_61124_((Property)ParkourBlock.DISGUISED, (Comparable)Boolean.TRUE)).m_61124_(ParkourBlock.DISGUISE_TYPE, (Comparable)((Object)disguiseType));
        this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        this.f_58857_.m_7260_(this.m_58899_(), currentState, newState, 3);
        if (this.f_58857_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            serverLevel.m_7726_().m_8450_(this.m_58899_());
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Updated block state to show disguise at {} with disguise type {}", (Object)this.m_58899_(), (Object)disguiseType.name());
        }
    }

    private <T extends Comparable<T>> String getPropertyValueAsString(BlockState state, Property<T> property) {
        return property.m_6940_(state.m_61143_(property));
    }

    private <T extends Comparable<T>> BlockState applyPropertyValue(BlockState state, Property<T> property, String valueString) {
        Optional value = property.m_6215_(valueString);
        if (value.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)value.get());
        }
        return state;
    }

    public void applyEffectsToPlayer(Player player) {
        if (this.effects.isEmpty()) {
            if (ModConfig.debugMode) {
                LOGGER.info("No effects to apply to player {} at {}", (Object)player.m_7755_().getString(), (Object)this.m_58899_());
            }
            return;
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Applying {} effects to player {} at {}", new Object[]{this.effects.size(), player.m_7755_().getString(), this.m_58899_()});
        }
        for (MobEffectInstance effect : this.effects) {
            MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_(), false, false, true);
            player.m_7292_(newEffect);
            if (!ModConfig.debugMode) continue;
            LOGGER.info("Applied effect {} (Level: {}, Duration: {} ticks) to player {} with particles disabled", new Object[]{effect.m_19544_().m_19481_(), effect.m_19564_(), effect.m_19557_(), player.m_7755_().getString()});
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag effectsList = new ListTag();
        for (MobEffectInstance effect : this.effects) {
            CompoundTag effectTag = new CompoundTag();
            ResourceLocation effectId = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_());
            effectTag.m_128359_("Id", effectId.toString());
            effectTag.m_128405_("Amplifier", effect.m_19564_());
            effectTag.m_128405_("Duration", effect.m_19557_());
            effectsList.add((Object)effectTag);
            if (!ModConfig.debugMode) continue;
            LOGGER.info("Saving effect to NBT: {}, Level: {}, Duration: {} ticks", new Object[]{effectId, effect.m_19564_(), effect.m_19557_()});
        }
        tag.m_128365_("Effects", (Tag)effectsList);
        tag.m_128365_("MovementSequence", (Tag)this.movementSequence.save());
        tag.m_128379_("MovementEnabled", this.movementEnabled);
        tag.m_128379_("DestroyBlocks", this.destroyBlocks);
        tag.m_128379_("IsBlocked", this.isBlocked);
        tag.m_128379_("IsPaused", this.isPaused);
        tag.m_128405_("MovementSpeed", this.movementSpeed);
        if (this.originalPos != null) {
            tag.m_128405_("OriginalPosX", this.originalPos.m_123341_());
            tag.m_128405_("OriginalPosY", this.originalPos.m_123342_());
            tag.m_128405_("OriginalPosZ", this.originalPos.m_123343_());
        }
        if (this.disguiseState != null) {
            CompoundTag stateTag = new CompoundTag();
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)this.disguiseState.m_60734_());
            stateTag.m_128359_("Name", blockId.toString());
            CompoundTag propertiesTag = new CompoundTag();
            for (Property property : this.disguiseState.m_61147_()) {
                String propertyName = property.m_61708_();
                String propertyValue = this.getPropertyValueAsString(this.disguiseState, property);
                propertiesTag.m_128359_(propertyName, propertyValue);
            }
            if (!propertiesTag.m_128456_()) {
                stateTag.m_128365_("Properties", (Tag)propertiesTag);
            }
            tag.m_128365_("DisguiseState", (Tag)stateTag);
            if (ModConfig.debugMode) {
                LOGGER.info("Saved disguise state to NBT: {} with {} properties", (Object)blockId, (Object)propertiesTag.m_128440_());
            }
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Saved {} effects and movement sequence with {} steps (enabled: {}, destroyBlocks: {}, blocked: {}) to NBT for ParkourBlockEntity at {}", new Object[]{this.effects.size(), this.movementSequence.getSteps().size(), this.movementEnabled, this.destroyBlocks, this.isBlocked, this.m_58899_()});
            if (this.originalPos != null) {
                LOGGER.info("Saved original position: {}", (Object)this.originalPos);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.effects.clear();
        if (tag.m_128441_("Effects")) {
            ListTag effectsList = tag.m_128437_("Effects", 10);
            if (ModConfig.debugMode) {
                LOGGER.info("Loading {} effects from NBT for ParkourBlockEntity at {}", (Object)effectsList.size(), (Object)this.m_58899_());
            }
            for (int i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectTag = effectsList.m_128728_(i);
                ResourceLocation effectId = ResourceLocation.m_135820_((String)effectTag.m_128461_("Id"));
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                int amplifier = effectTag.m_128451_("Amplifier");
                int duration = effectTag.m_128451_("Duration");
                this.effects.add(new MobEffectInstance(effect, duration, amplifier));
                if (!ModConfig.debugMode) continue;
                LOGGER.info("Loaded effect from NBT: {}, Level: {}, Duration: {} ticks", new Object[]{effectId, amplifier, duration});
            }
        } else if (ModConfig.debugMode) {
            LOGGER.info("No effects found in NBT for ParkourBlockEntity at {}", (Object)this.m_58899_());
        }
        if (tag.m_128441_("MovementSequence")) {
            CompoundTag movementTag = tag.m_128469_("MovementSequence");
            this.movementSequence = MovementSequence.load(movementTag);
            this.movementEnabled = tag.m_128441_("MovementEnabled") ? tag.m_128471_("MovementEnabled") : false;
            this.destroyBlocks = tag.m_128441_("DestroyBlocks") ? tag.m_128471_("DestroyBlocks") : false;
            this.isBlocked = tag.m_128441_("IsBlocked") ? tag.m_128471_("IsBlocked") : false;
            this.isPaused = tag.m_128441_("IsPaused") ? tag.m_128471_("IsPaused") : false;
            this.movementSpeed = tag.m_128441_("MovementSpeed") ? tag.m_128451_("MovementSpeed") : 10;
            if (tag.m_128441_("OriginalPosX") && tag.m_128441_("OriginalPosY") && tag.m_128441_("OriginalPosZ")) {
                int x = tag.m_128451_("OriginalPosX");
                int y = tag.m_128451_("OriginalPosY");
                int z = tag.m_128451_("OriginalPosZ");
                this.originalPos = new BlockPos(x, y, z);
            } else {
                this.originalPos = this.m_58899_().m_7949_();
            }
            if (tag.m_128441_("DisguiseState")) {
                try {
                    CompoundTag stateTag = tag.m_128469_("DisguiseState");
                    String blockId = stateTag.m_128461_("Name");
                    ResourceLocation blockResLoc = ResourceLocation.m_135820_((String)blockId);
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockResLoc);
                    this.disguiseState = block.m_49966_();
                    if (stateTag.m_128441_("Properties")) {
                        CompoundTag propertiesTag = stateTag.m_128469_("Properties");
                        for (String propertyName : propertiesTag.m_128431_()) {
                            for (Property property : this.disguiseState.m_61147_()) {
                                if (!property.m_61708_().equals(propertyName)) continue;
                                String valueString = propertiesTag.m_128461_(propertyName);
                                this.disguiseState = this.applyPropertyValue(this.disguiseState, property, valueString);
                            }
                        }
                    }
                    if (ModConfig.debugMode) {
                        LOGGER.info("Loaded disguise state: {} for ParkourBlockEntity at {}", (Object)this.disguiseState.m_60734_().m_49954_().getString(), (Object)this.m_58899_());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load disguise state for ParkourBlockEntity at {}: {}", (Object)this.m_58899_(), (Object)e.getMessage());
                    this.disguiseState = null;
                }
            }
            if (ModConfig.debugMode) {
                LOGGER.info("Loaded movement sequence with {} steps (enabled: {}, destroyBlocks: {}, blocked: {}) from NBT for ParkourBlockEntity at {}", new Object[]{this.movementSequence.getSteps().size(), this.movementEnabled, this.destroyBlocks, this.isBlocked, this.m_58899_()});
                LOGGER.info("Original position: {}", (Object)this.originalPos);
            }
        } else {
            this.movementSequence = new MovementSequence();
            this.movementEnabled = false;
            this.destroyBlocks = false;
            this.isBlocked = false;
            this.originalPos = this.m_58899_().m_7949_();
            this.disguiseState = null;
            if (ModConfig.debugMode) {
                LOGGER.info("No movement sequence found in NBT, created default for ParkourBlockEntity at {}", (Object)this.m_58899_());
            }
        }
    }
}

