/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.gui;

import com.google.common.collect.Lists;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.client.gui.CustomEditBox;
import de.sarocesch.pakourblocks.client.gui.widget.ModernButton;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.network.NetworkHandler;
import de.sarocesch.pakourblocks.network.PacketSetBlockEffects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class EffectSelectionScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(EffectSelectionScreen.class);
    private final BlockPos blockPos;
    private final List<MobEffect> availableEffects;
    private final Map<MobEffect, Boolean> selectedEffects = new HashMap<MobEffect, Boolean>();
    private final Map<MobEffect, Integer> effectAmplifiers = new HashMap<MobEffect, Integer>();
    private final Map<MobEffect, Integer> effectDurations = new HashMap<MobEffect, Integer>();
    private EffectList effectList;
    private Button saveButton;
    private boolean effectsLoaded = false;

    public EffectSelectionScreen(BlockPos blockPos) {
        super((Component)Component.m_237115_((String)"screen.saroparkourblocks.effect_selection"));
        this.blockPos = blockPos;
        this.availableEffects = Lists.newArrayList((Iterator)BuiltInRegistries.f_256974_.iterator());
        for (MobEffect effect : this.availableEffects) {
            this.selectedEffects.put(effect, false);
            this.effectAmplifiers.put(effect, 1);
            this.effectDurations.put(effect, 1);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.effectsLoaded && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(this.blockPos);
            if (blockEntity instanceof ParkourBlockEntity) {
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                List<MobEffectInstance> existingEffects = parkourBlockEntity.getEffects();
                if (ModConfig.debugMode) {
                    LOGGER.info("Loading {} effects from block entity at {}", (Object)existingEffects.size(), (Object)this.blockPos);
                }
                for (MobEffect effect : this.availableEffects) {
                    this.selectedEffects.put(effect, false);
                    this.effectAmplifiers.put(effect, 1);
                    this.effectDurations.put(effect, 1);
                }
                for (MobEffectInstance effectInstance : existingEffects) {
                    MobEffect effect = effectInstance.m_19544_();
                    this.selectedEffects.put(effect, true);
                    int amplifier = effectInstance.m_19564_() + 1;
                    int duration = effectInstance.m_19557_() / 20;
                    this.effectAmplifiers.put(effect, amplifier);
                    this.effectDurations.put(effect, duration);
                    if (!ModConfig.debugMode) continue;
                    LOGGER.info("Loaded effect: {} with level {} and duration {}", new Object[]{effect.m_19481_(), amplifier, duration});
                }
                this.effectsLoaded = true;
            } else if (ModConfig.debugMode) {
                LOGGER.warn("No ParkourBlockEntity found at {} when trying to load effects", (Object)this.blockPos);
            }
        }
        this.effectList = new EffectList(this.f_96541_, this.f_96543_, this.f_96544_, 40, this.f_96544_ - 50, 25);
        this.m_7787_((GuiEventListener)this.effectList);
        this.saveButton = new ModernButton.Builder((Component)Component.m_237115_((String)"button.saroparkourblocks.save_effects"), button -> {
            this.saveEffects();
            this.m_7379_();
        }).pos(this.f_96543_ / 2 - 100, this.f_96544_ - 30).size(200, 20).greenScheme().build();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.effectList.refreshList();
    }

    private void saveEffects() {
        ArrayList<MobEffectInstance> effectInstances = new ArrayList<MobEffectInstance>();
        for (MobEffect effect : this.availableEffects) {
            if (!this.selectedEffects.get(effect).booleanValue()) continue;
            int amplifier = this.effectAmplifiers.getOrDefault(effect, 1);
            int durationInSeconds = this.effectDurations.getOrDefault(effect, 1);
            int durationInTicks = durationInSeconds * 20;
            MobEffectInstance effectInstance = new MobEffectInstance(effect, durationInTicks, amplifier - 1, false, false, true);
            effectInstances.add(effectInstance);
            if (!ModConfig.debugMode) continue;
            LOGGER.info("Saving effect: {} with level {} and duration {} seconds ({} ticks), particles disabled", new Object[]{effect.m_19481_(), amplifier - 1, durationInSeconds, durationInTicks});
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Saving {} effects to block at {}", (Object)effectInstances.size(), (Object)this.blockPos);
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetBlockEffects(this.blockPos, effectInstances));
        this.effectsLoaded = false;
    }

    private void renderModernBackground(GuiGraphics guiGraphics) {
        int topColor = -15066578;
        int bottomColor = -15790306;
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, topColor, bottomColor);
        for (int y = 0; y < this.f_96544_; y += 20) {
            guiGraphics.m_280509_(0, y, this.f_96543_, y + 1, 0x10FFFFFF);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderModernBackground(guiGraphics);
        this.effectList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, -1);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    class EffectList
    extends ObjectSelectionList<EffectEntry> {
        public EffectList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.m_93488_(false);
        }

        public void refreshList() {
            this.m_93516_();
            for (MobEffect effect : EffectSelectionScreen.this.availableEffects) {
                this.m_7085_((AbstractSelectionList.Entry)new EffectEntry(effect));
            }
        }

        public int m_5759_() {
            return this.f_93388_ - 40;
        }

        protected int m_5756_() {
            return this.f_93388_ - 10;
        }

        class EffectEntry
        extends ObjectSelectionList.Entry<EffectEntry> {
            private final MobEffect effect;
            private final Checkbox checkbox;
            private final CustomEditBox amplifierInput;
            private final CustomEditBox durationInput;
            private final Component effectName;

            public EffectEntry(MobEffect effect) {
                this.effect = effect;
                this.effectName = Component.m_237115_((String)effect.m_19481_());
                this.checkbox = new Checkbox(10, 0, 20, 20, (Component)Component.m_237119_(), EffectSelectionScreen.this.selectedEffects.get(effect).booleanValue());
                this.amplifierInput = new CustomEditBox(EffectSelectionScreen.this.f_96547_, EffectList.this.f_93388_ - 100, 0, 40, 20, 1);
                Integer amplifier = EffectSelectionScreen.this.effectAmplifiers.get(effect);
                if (amplifier != null) {
                    this.amplifierInput.m_94144_(String.valueOf(amplifier));
                } else {
                    this.amplifierInput.m_94144_("");
                }
                this.durationInput = new CustomEditBox(EffectSelectionScreen.this.f_96547_, EffectList.this.f_93388_ - 180, 0, 40, 20, 1);
                Integer duration = EffectSelectionScreen.this.effectDurations.get(effect);
                if (duration != null) {
                    this.durationInput.m_94144_(String.valueOf(duration));
                } else {
                    this.durationInput.m_94144_("");
                }
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.effectName});
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.checkbox.m_6375_(mouseX, mouseY, button)) {
                    EffectSelectionScreen.this.selectedEffects.put(this.effect, this.checkbox.m_93840_());
                    return true;
                }
                if (mouseX >= (double)this.amplifierInput.m_252754_() && mouseX < (double)(this.amplifierInput.m_252754_() + this.amplifierInput.m_5711_()) && mouseY >= (double)this.amplifierInput.m_252907_() && mouseY < (double)(this.amplifierInput.m_252907_() + this.amplifierInput.m_93694_())) {
                    this.amplifierInput.m_93692_(true);
                    this.amplifierInput.m_94201_();
                    this.amplifierInput.m_94144_("");
                    this.durationInput.m_93692_(false);
                    return true;
                }
                if (mouseX >= (double)this.durationInput.m_252754_() && mouseX < (double)(this.durationInput.m_252754_() + this.durationInput.m_5711_()) && mouseY >= (double)this.durationInput.m_252907_() && mouseY < (double)(this.durationInput.m_252907_() + this.durationInput.m_93694_())) {
                    this.durationInput.m_93692_(true);
                    this.durationInput.m_94201_();
                    this.durationInput.m_94144_("");
                    this.amplifierInput.m_93692_(false);
                    return true;
                }
                this.amplifierInput.m_93692_(false);
                this.durationInput.m_93692_(false);
                return false;
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                boolean handled = false;
                if (this.amplifierInput.m_93696_() && (handled = this.amplifierInput.m_7933_(keyCode, scanCode, modifiers))) {
                    EffectSelectionScreen.this.effectAmplifiers.put(this.effect, this.amplifierInput.getNumericValue());
                }
                if (this.durationInput.m_93696_() && (handled = this.durationInput.m_7933_(keyCode, scanCode, modifiers))) {
                    EffectSelectionScreen.this.effectDurations.put(this.effect, this.durationInput.getNumericValue());
                }
                return handled;
            }

            public boolean m_5534_(char c, int modifiers) {
                boolean handled = false;
                if (this.amplifierInput.m_93696_() && (handled = this.amplifierInput.m_5534_(c, modifiers))) {
                    EffectSelectionScreen.this.effectAmplifiers.put(this.effect, this.amplifierInput.getNumericValue());
                }
                if (this.durationInput.m_93696_() && (handled = this.durationInput.m_5534_(c, modifiers))) {
                    EffectSelectionScreen.this.effectDurations.put(this.effect, this.durationInput.getNumericValue());
                }
                return handled;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
                String expectedDuration;
                String currentDuration;
                String expectedAmplifier;
                String currentAmplifier;
                this.checkbox.m_252865_(left + 5);
                this.checkbox.m_253211_(top + 2);
                boolean shouldBeSelected = EffectSelectionScreen.this.selectedEffects.get(this.effect);
                if (this.checkbox.m_93840_() != shouldBeSelected) {
                    if (ModConfig.debugMode) {
                        LOGGER.info("Fixing checkbox state for effect {}: current={}, should={}", new Object[]{this.effect.m_19481_(), this.checkbox.m_93840_(), shouldBeSelected});
                    }
                    this.checkbox.m_5691_();
                }
                this.amplifierInput.m_252865_(left + width - 60);
                this.amplifierInput.m_253211_(top + 2);
                this.amplifierInput.m_93674_(40);
                this.durationInput.m_252865_(left + width - 160);
                this.durationInput.m_253211_(top + 2);
                this.durationInput.m_93674_(40);
                this.amplifierInput.m_94194_(true);
                this.amplifierInput.m_94186_(true);
                this.durationInput.m_94194_(true);
                this.durationInput.m_94186_(true);
                if (!this.amplifierInput.m_93696_() && !(currentAmplifier = this.amplifierInput.m_94155_()).equals(expectedAmplifier = String.valueOf(EffectSelectionScreen.this.effectAmplifiers.get(this.effect)))) {
                    if (ModConfig.debugMode) {
                        LOGGER.info("Fixing amplifier value for effect {}: current={}, should={}", new Object[]{this.effect.m_19481_(), currentAmplifier, expectedAmplifier});
                    }
                    this.amplifierInput.m_94144_(expectedAmplifier);
                }
                if (!this.durationInput.m_93696_() && !(currentDuration = this.durationInput.m_94155_()).equals(expectedDuration = String.valueOf(EffectSelectionScreen.this.effectDurations.get(this.effect)))) {
                    if (ModConfig.debugMode) {
                        LOGGER.info("Fixing duration value for effect {}: current={}, should={}", new Object[]{this.effect.m_19481_(), currentDuration, expectedDuration});
                    }
                    this.durationInput.m_94144_(expectedDuration);
                }
                this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                this.amplifierInput.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                this.durationInput.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                int maxWidth = width - 220;
                List lines = EffectSelectionScreen.this.f_96547_.m_92923_((FormattedText)this.effectName, maxWidth);
                if (!lines.isEmpty()) {
                    guiGraphics.m_280648_(EffectSelectionScreen.this.f_96547_, (FormattedCharSequence)lines.get(0), left + 30, top + 7, 0xFFFFFF);
                }
                guiGraphics.m_280488_(EffectSelectionScreen.this.f_96547_, "Level:", left + width - 100, top + 7, 0xFFFFFF);
                guiGraphics.m_280488_(EffectSelectionScreen.this.f_96547_, "Duration:", left + width - 210, top + 7, 0xFFFFFF);
            }
        }
    }
}

