/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.client.gui.widget.ModernButton;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.movement.MovementSequence;
import de.sarocesch.pakourblocks.movement.MovementStep;
import de.sarocesch.pakourblocks.network.NetworkHandler;
import de.sarocesch.pakourblocks.network.PacketSetMovementSequence;
import de.sarocesch.pakourblocks.network.PacketSetPaused;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class MovingBlockScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovingBlockScreen.class);
    private final BlockPos blockPos;
    private boolean destroyBlocks = true;
    private boolean movementEnabled = true;
    private int movementSpeed = 10;
    private Button saveButton;
    private Button destroyBlocksButton;
    private Button enableButton;
    private Button clearPathButton;
    private Button undoButton;
    private EditBox speedInput;
    private float rotationX = 30.0f;
    private float rotationY = 45.0f;
    private float scale = 16.0f;
    private BlockState blockState;
    private List<BlockPos> clickedPath = new ArrayList<BlockPos>();
    private int currentYLevel = 0;
    private int gridOffsetX = 0;
    private int gridOffsetZ = 0;
    private static final int GRID_VISIBLE_SIZE = 5;
    private long lastUpdateTime = 0L;
    private int animationStep = 0;
    private boolean animating = false;
    private static final int ANIMATION_SPEED = 500;
    private int previewCenterX;
    private int previewCenterY;
    private static final int PREVIEW_SIZE = 150;
    private Button yUpButton;
    private Button yDownButton;
    private boolean isDragging = false;
    private int lastMouseX;
    private int lastMouseY;

    public MovingBlockScreen(BlockPos blockPos) {
        super((Component)Component.m_237115_((String)"screen.saroparkourblocks.moving_block_settings"));
        this.blockPos = blockPos;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.previewCenterX = this.f_96543_ / 2;
        this.previewCenterY = this.f_96544_ / 2 - 20;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            BlockEntity blockEntity;
            block14: {
                BlockEntity blockEntity2;
                this.blockState = this.f_96541_.f_91073_.m_8055_(this.blockPos);
                if (this.blockState.m_60734_() instanceof ParkourBlock && this.blockState.m_61138_((Property)ParkourBlock.DISGUISED) && ((Boolean)this.blockState.m_61143_((Property)ParkourBlock.DISGUISED)).booleanValue() && (blockEntity2 = this.f_96541_.f_91073_.m_7702_(this.blockPos)) instanceof ParkourBlockEntity) {
                    ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity2;
                    BlockState disguiseState = parkourBlockEntity.getDisguiseState();
                    if (disguiseState != null) {
                        this.blockState = disguiseState;
                        if (ModConfig.debugMode) {
                            LOGGER.info("Using disguise state from block entity for rendering: {}", (Object)disguiseState.m_60734_().m_49954_().getString());
                        }
                    } else {
                        ParkourBlock.DisguiseType disguiseType = null;
                        disguiseType = this.blockState.m_61138_(ParkourBlock.DISGUISE_TYPE) ? (ParkourBlock.DisguiseType)((Object)this.blockState.m_61143_(ParkourBlock.DISGUISE_TYPE)) : ParkourBlock.DisguiseType.STONE;
                        try {
                            String blockId = disguiseType.getBlockId();
                            ResourceLocation blockResLoc = ResourceLocation.m_135820_((String)blockId);
                            if (blockResLoc != null) {
                                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockResLoc);
                                this.blockState = disguiseState = block.m_49966_();
                                if (ModConfig.debugMode) {
                                    LOGGER.info("Using disguise state from disguise type for rendering: {}", (Object)disguiseType);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!ModConfig.debugMode) break block14;
                            LOGGER.error("Error getting disguise state from disguise type: {}", (Object)e.getMessage());
                        }
                    }
                }
            }
            if (this.clickedPath.isEmpty() && (blockEntity = this.f_96541_.f_91073_.m_7702_(this.blockPos)) instanceof ParkourBlockEntity) {
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                this.destroyBlocks = parkourBlockEntity.canDestroyBlocks();
                this.movementEnabled = parkourBlockEntity.isMovementEnabled();
                MovementSequence sequence = parkourBlockEntity.getMovementSequence();
                BlockPos currentPos = BlockPos.f_121853_;
                this.clickedPath.add(currentPos);
                this.movementSpeed = !sequence.getSteps().isEmpty() ? sequence.getSteps().get(0).getSpeed() : parkourBlockEntity.getMovementSpeed();
                for (MovementStep step : sequence.getSteps()) {
                    Direction direction = step.getDirection();
                    int distance = step.getDistance();
                    for (int i = 0; i < distance; ++i) {
                        currentPos = currentPos.m_121945_(direction);
                        this.clickedPath.add(currentPos);
                    }
                }
                if (ModConfig.debugMode) {
                    LOGGER.info("Loaded movement path with {} positions from block entity", (Object)this.clickedPath.size());
                }
            }
        }
        if (this.clickedPath.isEmpty()) {
            this.clickedPath.add(BlockPos.f_121853_);
        }
        int centerX = this.f_96543_ / 2;
        int leftX = 20;
        int rightX = this.f_96543_ - 220;
        this.yUpButton = new ModernButton.Builder((Component)Component.m_237113_((String)"Y +"), button -> ++this.currentYLevel).pos(leftX, this.f_96544_ - 150).size(48, 20).purpleScheme().build();
        this.m_142416_((GuiEventListener)this.yUpButton);
        this.yDownButton = new ModernButton.Builder((Component)Component.m_237113_((String)"Y -"), button -> --this.currentYLevel).pos(leftX + 52, this.f_96544_ - 150).size(48, 20).purpleScheme().build();
        this.m_142416_((GuiEventListener)this.yDownButton);
        this.clearPathButton = new ModernButton.Builder((Component)Component.m_237113_((String)"Clear Path"), button -> {
            this.clickedPath.clear();
            this.clickedPath.add(BlockPos.f_121853_);
            this.animating = false;
            this.currentYLevel = 0;
        }).pos(leftX, this.f_96544_ - 120).size(100, 20).redScheme().build();
        this.m_142416_((GuiEventListener)this.clearPathButton);
        this.undoButton = new ModernButton.Builder((Component)Component.m_237113_((String)"Undo"), button -> {
            if (this.clickedPath.size() > 1) {
                this.clickedPath.remove(this.clickedPath.size() - 1);
                this.animating = false;
            }
        }).pos(leftX, this.f_96544_ - 90).size(100, 20).grayScheme().build();
        this.m_142416_((GuiEventListener)this.undoButton);
        this.speedInput = new EditBox(this.f_96547_, leftX, this.f_96544_ - 60, 100, 20, (Component)Component.m_237113_((String)"Speed"));
        this.speedInput.m_94144_(String.valueOf(this.movementSpeed));
        this.speedInput.m_94199_(3);
        this.speedInput.m_94151_(value -> {
            try {
                int speed = Integer.parseInt(value);
                if (speed > 0 && speed <= 100) {
                    this.movementSpeed = speed;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.speedInput);
        this.enableButton = new ModernButton.Builder((Component)Component.m_237113_((String)(this.movementEnabled ? "Movement: Enabled" : "Movement: Disabled")), button -> {
            this.movementEnabled = !this.movementEnabled;
            button.m_93666_((Component)Component.m_237113_((String)(this.movementEnabled ? "Movement: Enabled" : "Movement: Disabled")));
        }).pos(rightX, this.f_96544_ - 90).size(200, 20).build();
        this.m_142416_((GuiEventListener)this.enableButton);
        this.destroyBlocksButton = new ModernButton.Builder((Component)Component.m_237113_((String)(this.destroyBlocks ? "Destroy Blocks: Enabled" : "Destroy Blocks: Disabled")), button -> {
            this.destroyBlocks = !this.destroyBlocks;
            button.m_93666_((Component)Component.m_237113_((String)(this.destroyBlocks ? "Destroy Blocks: Enabled" : "Destroy Blocks: Disabled")));
        }).pos(rightX, this.f_96544_ - 60).size(200, 20).build();
        this.m_142416_((GuiEventListener)this.destroyBlocksButton);
        this.saveButton = new ModernButton.Builder((Component)Component.m_237113_((String)"Save Movement"), button -> this.saveMovement()).pos(rightX, this.f_96544_ - 30).size(200, 20).greenScheme().build();
        this.m_142416_((GuiEventListener)this.saveButton);
    }

    private List<MovementStep> convertPathToSteps() {
        ArrayList<MovementStep> steps = new ArrayList<MovementStep>();
        if (this.clickedPath.size() < 2) {
            return steps;
        }
        BlockPos currentPos = this.clickedPath.get(0);
        Direction currentDirection = null;
        int currentDistance = 0;
        for (int i = 1; i < this.clickedPath.size(); ++i) {
            BlockPos nextPos = this.clickedPath.get(i);
            BlockPos delta = nextPos.m_121996_((Vec3i)currentPos);
            Direction direction = this.getDirectionFromDelta(delta);
            if (direction == null) {
                if (!ModConfig.debugMode) continue;
                LOGGER.warn("Invalid movement from {} to {}, skipping", (Object)currentPos, (Object)nextPos);
                continue;
            }
            if (direction == currentDirection) {
                ++currentDistance;
            } else {
                if (currentDirection != null && currentDistance > 0) {
                    steps.add(new MovementStep(currentDirection, currentDistance, this.movementSpeed));
                }
                currentDirection = direction;
                currentDistance = 1;
            }
            currentPos = nextPos;
        }
        if (currentDirection != null && currentDistance > 0) {
            steps.add(new MovementStep(currentDirection, currentDistance, this.movementSpeed));
        }
        return steps;
    }

    private Direction getDirectionFromDelta(BlockPos delta) {
        if (delta.m_123341_() == 1 && delta.m_123342_() == 0 && delta.m_123343_() == 0) {
            return Direction.EAST;
        }
        if (delta.m_123341_() == -1 && delta.m_123342_() == 0 && delta.m_123343_() == 0) {
            return Direction.WEST;
        }
        if (delta.m_123341_() == 0 && delta.m_123342_() == 1 && delta.m_123343_() == 0) {
            return Direction.UP;
        }
        if (delta.m_123341_() == 0 && delta.m_123342_() == -1 && delta.m_123343_() == 0) {
            return Direction.DOWN;
        }
        if (delta.m_123341_() == 0 && delta.m_123342_() == 0 && delta.m_123343_() == 1) {
            return Direction.SOUTH;
        }
        if (delta.m_123341_() == 0 && delta.m_123342_() == 0 && delta.m_123343_() == -1) {
            return Direction.NORTH;
        }
        return null;
    }

    private void saveMovement() {
        LOGGER.info("Save button clicked");
        List<MovementStep> steps = this.convertPathToSteps();
        MovementSequence sequence = new MovementSequence();
        sequence.setLoop(true);
        for (MovementStep step : steps) {
            sequence.addStep(step);
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Saving movement sequence with {} steps (enabled: {})", (Object)sequence.getSteps().size(), (Object)this.movementEnabled);
            LOGGER.info("Clicked path has {} positions", (Object)this.clickedPath.size());
            int stepIndex = 0;
            for (MovementStep step : sequence.getSteps()) {
                LOGGER.info("  Step {}: {} {} blocks at {} ticks/block", new Object[]{stepIndex++, step.getDirection().m_122433_(), step.getDistance(), step.getSpeed()});
            }
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetMovementSequence(this.blockPos, sequence, this.movementEnabled, this.destroyBlocks));
        LOGGER.info("Sending movement sequence packet to server with {} steps", (Object)sequence.getSteps().size());
        this.f_96541_.execute(() -> this.m_7379_());
    }

    private void renderModernBackground(GuiGraphics guiGraphics) {
        int topColor = -15066578;
        int bottomColor = -15790306;
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, topColor, bottomColor);
        for (int y = 0; y < this.f_96544_; y += 20) {
            guiGraphics.m_280509_(0, y, this.f_96543_, y + 1, 0x10FFFFFF);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderModernBackground(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, -1);
        guiGraphics.m_280137_(this.f_96547_, "Click on the grid (left) to select blocks for the movement path", this.f_96543_ / 2, 30, -5197648);
        guiGraphics.m_280137_(this.f_96547_, "Path length: " + (this.clickedPath.size() - 1) + " blocks", this.f_96543_ / 2, 45, -1);
        guiGraphics.m_280488_(this.f_96547_, "Speed (ticks/block):", 20, this.f_96544_ - 72, -5197648);
        this.renderGridSelector(guiGraphics, mouseX, mouseY);
        if (this.clickedPath.size() > 1) {
            long currentTime;
            String playPauseText = this.animating ? "\u25a0 Stop" : "\u25b6 Play";
            guiGraphics.m_280488_(this.f_96547_, playPauseText, this.f_96543_ / 2 - 150, this.previewCenterY - 150 - 20, 0xFFFFFF);
            if (this.animating && (currentTime = System.currentTimeMillis()) - this.lastUpdateTime > 500L) {
                this.lastUpdateTime = currentTime;
                this.animationStep = (this.animationStep + 1) % this.clickedPath.size();
            }
        }
        if (this.blockState != null && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.renderBlockPreview(guiGraphics, this.previewCenterX, this.previewCenterY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderGridSelector(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int gridStartX = this.previewCenterX - 150 - 120;
        int gridStartY = this.previewCenterY - 60;
        int gridSize = 20;
        guiGraphics.m_280488_(this.f_96547_, "Block Selector (Y: " + this.currentYLevel + ")", gridStartX, gridStartY - 25, -1);
        guiGraphics.m_280488_(this.f_96547_, "Scroll: Up/Down | Shift+Scroll: Left/Right", gridStartX, gridStartY - 13, -5197648);
        for (int gridX = 0; gridX < 5; ++gridX) {
            for (int gridY = 0; gridY < 5; ++gridY) {
                int x = gridX - 2 + this.gridOffsetX;
                int z = gridY - 2 + this.gridOffsetZ;
                int cellX = gridStartX + gridX * gridSize;
                int cellY = gridStartY + gridY * gridSize;
                boolean hasBlock = false;
                if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                    BlockPos worldPos = this.blockPos.m_7918_(x, this.currentYLevel, z);
                    BlockState state = this.f_96541_.f_91073_.m_8055_(worldPos);
                    hasBlock = !state.m_60795_();
                }
                boolean inPath = false;
                for (BlockPos pos : this.clickedPath) {
                    if (pos.m_123341_() != x || pos.m_123342_() != this.currentYLevel || pos.m_123343_() != z) continue;
                    inPath = true;
                    break;
                }
                int color = inPath ? -16711936 : (hasBlock ? -10066330 : -12303292);
                guiGraphics.m_280509_(cellX, cellY, cellX + gridSize - 1, cellY + gridSize - 1, color);
                guiGraphics.m_280509_(cellX, cellY, cellX + gridSize, cellY + 1, -1);
                guiGraphics.m_280509_(cellX, cellY, cellX + 1, cellY + gridSize, -1);
                guiGraphics.m_280509_(cellX + gridSize - 1, cellY, cellX + gridSize, cellY + gridSize, -1);
                guiGraphics.m_280509_(cellX, cellY + gridSize - 1, cellX + gridSize, cellY + gridSize, -1);
                if (x != 0 || z != 0) continue;
                guiGraphics.m_280137_(this.f_96547_, "P", cellX + gridSize / 2, cellY + gridSize / 2 - 4, 0xFFFFFF);
            }
        }
    }

    private void renderBlockPreview(GuiGraphics guiGraphics, int centerX, int centerY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 100.0f);
        poseStack.m_85841_(this.scale, -this.scale, this.scale);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotationX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotationY));
        BlockRenderDispatcher blockRenderer = this.f_96541_.m_91289_();
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        this.renderTerrain(poseStack, blockRenderer, bufferSource);
        if (this.animating && this.clickedPath.size() > 1) {
            BlockPos currentPos = this.clickedPath.get(this.animationStep);
            this.renderBlock(poseStack, blockRenderer, bufferSource, this.blockState, currentPos, -1);
            this.renderPathIndicator(poseStack, bufferSource, currentPos, -16711936);
        } else {
            this.renderBlock(poseStack, blockRenderer, bufferSource, this.blockState, BlockPos.f_121853_, -1);
            for (int i = 0; i < this.clickedPath.size(); ++i) {
                BlockPos pathPos = this.clickedPath.get(i);
                int color = i == 0 ? -16711936 : -256;
                this.renderPathIndicator(poseStack, bufferSource, pathPos, color);
            }
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    private void renderTerrain(PoseStack poseStack, BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource bufferSource) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos worldPos;
                    BlockState state;
                    if (x == 0 && y == 0 && z == 0 || (state = this.f_96541_.f_91073_.m_8055_(worldPos = this.blockPos.m_7918_(x, y, z))).m_60795_()) continue;
                    this.renderBlock(poseStack, blockRenderer, bufferSource, state, new BlockPos(x, y, z), -1);
                }
            }
        }
    }

    private void renderBlock(PoseStack poseStack, BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource bufferSource, BlockState state, BlockPos pos, int color) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        BakedModel model = blockRenderer.m_110910_(state);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        blockRenderer.m_110912_(state, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private void renderBlockOutline(PoseStack poseStack, GuiGraphics guiGraphics, BlockPos pos, int color) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        poseStack.m_85849_();
    }

    private void renderPathIndicator(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, BlockPos pos, int color) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 0.5f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        BlockState glassState = Blocks.f_50058_.m_49966_();
        BlockRenderDispatcher blockRenderer = this.f_96541_.m_91289_();
        blockRenderer.m_110912_(glassState, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BlockPos clickedBlock;
        if (this.clickedPath.size() > 1 && mouseY >= (double)(this.previewCenterY - 150 - 20 - 10) && mouseY <= (double)(this.previewCenterY - 150 - 20 + 10) && mouseX >= (double)(this.f_96543_ / 2 - 150) && mouseX <= (double)(this.f_96543_ / 2 - 150 + 50) && button == 0) {
            boolean bl = this.animating = !this.animating;
            if (this.animating) {
                this.lastUpdateTime = System.currentTimeMillis();
                this.animationStep = 0;
            }
            return true;
        }
        if (button == 0 && (clickedBlock = this.getBlockAtMouse(mouseX, mouseY)) != null) {
            boolean alreadyInPath = false;
            int pathIndex = -1;
            for (int i = 0; i < this.clickedPath.size(); ++i) {
                if (!this.clickedPath.get(i).equals((Object)clickedBlock)) continue;
                alreadyInPath = true;
                pathIndex = i;
                break;
            }
            if (!alreadyInPath) {
                this.clickedPath.add(clickedBlock);
                this.animating = false;
                if (ModConfig.debugMode) {
                    LOGGER.info("Added block to path: {}, total path length: {}", (Object)clickedBlock, (Object)this.clickedPath.size());
                }
            } else if (this.clickedPath.size() > 1 && pathIndex > 0) {
                this.clickedPath.remove(pathIndex);
                this.animating = false;
                if (ModConfig.debugMode) {
                    LOGGER.info("Removed block from path: {}, total path length: {}", (Object)clickedBlock, (Object)this.clickedPath.size());
                }
            } else if (ModConfig.debugMode) {
                LOGGER.info("Cannot remove origin block from path");
            }
            return true;
        }
        if (mouseX >= (double)(this.previewCenterX - 150) && mouseX <= (double)(this.previewCenterX + 150) && mouseY >= (double)(this.previewCenterY - 150) && mouseY <= (double)(this.previewCenterY + 150) && button == 0) {
            this.isDragging = true;
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private BlockPos getBlockAtMouse(double mouseX, double mouseY) {
        int gridStartX = this.previewCenterX - 150 - 120;
        int gridStartY = this.previewCenterY - 60;
        int gridSize = 20;
        if (mouseX >= (double)gridStartX && mouseX < (double)(gridStartX + gridSize * 5) && mouseY >= (double)gridStartY && mouseY < (double)(gridStartY + gridSize * 5)) {
            int gridX = (int)((mouseX - (double)gridStartX) / (double)gridSize);
            int gridY = (int)((mouseY - (double)gridStartY) / (double)gridSize);
            int x = gridX - 2 + this.gridOffsetX;
            int z = gridY - 2 + this.gridOffsetZ;
            BlockPos clickedPos = new BlockPos(x, this.currentYLevel, z);
            return clickedPos;
        }
        return null;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDragging && button == 0) {
            this.isDragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && button == 0) {
            this.rotationY = (float)((double)this.rotationY + (mouseX - (double)this.lastMouseX) * 1.0);
            this.rotationX = (float)((double)this.rotationX + (mouseY - (double)this.lastMouseY) * 1.0);
            this.rotationX = Math.max(0.0f, Math.min(90.0f, this.rotationX));
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int gridStartX = this.previewCenterX - 150 - 120;
        int gridStartY = this.previewCenterY - 60;
        int gridSize = 20;
        if (mouseX >= (double)gridStartX && mouseX < (double)(gridStartX + gridSize * 5) && mouseY >= (double)gridStartY && mouseY < (double)(gridStartY + gridSize * 5)) {
            if (Screen.m_96638_()) {
                this.gridOffsetX -= (int)delta;
            } else {
                this.gridOffsetZ -= (int)delta;
            }
            return true;
        }
        if (mouseX >= (double)(this.previewCenterX - 150) && mouseX <= (double)(this.previewCenterX + 150) && mouseY >= (double)(this.previewCenterY - 150) && mouseY <= (double)(this.previewCenterY + 150)) {
            this.scale = (float)((double)this.scale + delta * 2.0);
            this.scale = Math.max(4.0f, Math.min(32.0f, this.scale));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        ParkourBlockEntity parkourBlockEntity;
        BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(this.blockPos);
        if (blockEntity instanceof ParkourBlockEntity && (parkourBlockEntity = (ParkourBlockEntity)blockEntity).isMovementEnabled() && parkourBlockEntity.isPaused()) {
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetPaused(this.blockPos, false));
            if (ModConfig.debugMode) {
                LOGGER.info("Unpausing block at {} when closing screen", (Object)this.blockPos);
            }
        }
        super.m_7379_();
    }
}

