/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.model;

import com.mojang.logging.LogUtils;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ParkourBlockBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ModelProperty<BlockState> DISGUISE_PROPERTY = new ModelProperty();
    private final BakedModel originalModel;

    public ParkourBlockBakedModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.originalModel.m_213637_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        BakedModel disguiseModel;
        BlockState disguiseState = (BlockState)extraData.get(DISGUISE_PROPERTY);
        if (disguiseState != null && (disguiseModel = Minecraft.m_91087_().m_91289_().m_110910_(disguiseState)) != null) {
            return disguiseModel.getQuads(disguiseState, side, rand, ModelData.EMPTY, renderType);
        }
        return this.originalModel.getQuads(state, side, rand, extraData, renderType);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null) {
            return ModelData.builder().with(DISGUISE_PROPERTY, (Object)disguiseState).build();
        }
        return ModelData.EMPTY;
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BakedModel disguiseModel;
        BlockState disguiseState = (BlockState)data.get(DISGUISE_PROPERTY);
        if (disguiseState != null && (disguiseModel = Minecraft.m_91087_().m_91289_().m_110910_(disguiseState)) != null) {
            return disguiseModel.getParticleIcon(ModelData.EMPTY);
        }
        return this.originalModel.getParticleIcon(data);
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()});
    }
}

