/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.network;

import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.movement.MovementSequence;
import de.sarocesch.pakourblocks.movement.MovementStep;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSetMovementSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSetMovementSequence.class);
    private final BlockPos pos;
    private final MovementSequence sequence;
    private final boolean movementEnabled;
    private final boolean destroyBlocks;

    public PacketSetMovementSequence(BlockPos pos, MovementSequence sequence, boolean movementEnabled, boolean destroyBlocks) {
        this.pos = pos;
        this.sequence = sequence;
        this.movementEnabled = movementEnabled;
        this.destroyBlocks = destroyBlocks;
    }

    public PacketSetMovementSequence(BlockPos pos, MovementSequence sequence, boolean movementEnabled) {
        this(pos, sequence, movementEnabled, false);
    }

    public static void encode(PacketSetMovementSequence msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.movementEnabled);
        buf.writeBoolean(msg.destroyBlocks);
        buf.writeBoolean(msg.sequence.isLoop());
        buf.writeInt(msg.sequence.getSteps().size());
        for (MovementStep step : msg.sequence.getSteps()) {
            buf.writeInt(step.getDirection().ordinal());
            buf.writeInt(step.getDistance());
            buf.writeInt(step.getSpeed());
        }
    }

    public static PacketSetMovementSequence decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean movementEnabled = buf.readBoolean();
        boolean destroyBlocks = buf.readBoolean();
        boolean loop = buf.readBoolean();
        MovementSequence sequence = new MovementSequence();
        sequence.setLoop(loop);
        sequence.getSteps().clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int dirIndex = buf.readInt();
            Direction direction = Direction.values()[dirIndex];
            int distance = buf.readInt();
            int speed = buf.readInt();
            sequence.addStep(new MovementStep(direction, distance, speed));
        }
        return new PacketSetMovementSequence(pos, sequence, movementEnabled, destroyBlocks);
    }

    public static void handle(PacketSetMovementSequence msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(msg.pos)) instanceof ParkourBlockEntity) {
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                if (ModConfig.debugMode) {
                    LOGGER.info("Setting movement sequence with {} steps (enabled: {}, destroyBlocks: {}) on block at {}", new Object[]{msg.sequence.getSteps().size(), msg.movementEnabled, msg.destroyBlocks, msg.pos});
                }
                if (ModConfig.debugMode) {
                    LOGGER.info("Received sequence with {} steps:", (Object)msg.sequence.getSteps().size());
                    int stepIndex = 0;
                    for (MovementStep step : msg.sequence.getSteps()) {
                        LOGGER.info("  Step {}: {} {} blocks at {} ticks/block", new Object[]{stepIndex++, step.getDirection().m_122433_(), step.getDistance(), step.getSpeed()});
                    }
                }
                parkourBlockEntity.setMovementSequence(msg.sequence);
                parkourBlockEntity.setMovementEnabled(msg.movementEnabled);
                parkourBlockEntity.setDestroyBlocks(msg.destroyBlocks);
                parkourBlockEntity.setBlocked(false);
                if (!msg.sequence.getSteps().isEmpty()) {
                    int speed = msg.sequence.getSteps().get(0).getSpeed();
                    parkourBlockEntity.setMovementSpeed(speed);
                }
                parkourBlockEntity.m_6596_();
                BlockState state = player.m_9236_().m_8055_(msg.pos);
                player.m_9236_().m_7260_(msg.pos, state, state, 3);
                player.m_9236_().m_46745_(msg.pos).m_8092_(true);
                parkourBlockEntity.m_6596_();
                LOGGER.info("Saved movement sequence data for block at {}", (Object)msg.pos);
                player.m_213846_((Component)Component.m_237113_((String)("Movement sequence updated: " + msg.sequence.getSteps().size() + " steps set, movement " + (msg.movementEnabled ? "enabled" : "disabled") + ", destroy blocks " + (msg.destroyBlocks ? "enabled" : "disabled"))));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

