/*
 * Decompiled with CFR 0.152.
 */
package malfu.wandering_orc.entity.ai;

import java.util.EnumSet;
import malfu.wandering_orc.entity.custom.MinotaurEntity;
import malfu.wandering_orc.entity.custom.OrcGroupEntity;
import malfu.wandering_orc.sound.ModSounds;
import malfu.wandering_orc.util.AreaDamage;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;

public class MinotaurMeleeGoal
extends class_1352 {
    private final MinotaurEntity orc;
    private class_1309 target;
    private int attackCooldown;
    private int stompCooldown;
    private double speed;
    private int attackCondition = 0;
    double randomizer;
    private int initialcooldown = 80;
    private int normalattack = 9;
    private int holdattack = 25;
    private int holdmeattack = 39;
    private int stompaoe = 25;
    private int stopAttackCD;

    public MinotaurMeleeGoal(MinotaurEntity orc, double speed) {
        this.orc = orc;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405));
    }

    protected void stompSound() {
        this.orc.method_5783(ModSounds.MINO_STOMP, 1.0f, 1.0f);
    }

    private void generateParticles() {
        class_243 sourcePos = this.orc.method_19538();
        if (this.orc.method_37908().method_8608()) {
            return;
        }
        ((class_3218)this.orc.method_37908()).method_14199((class_2394)class_2398.field_11236, sourcePos.field_1352, sourcePos.field_1351, sourcePos.field_1350, 20, 1.0, 1.0, 1.0, 1.0);
    }

    private void stompAttack() {
        class_1937 world = this.orc.method_37908();
        class_2338 centerPos = this.orc.method_24515();
        AreaDamage.dealAreaDamageWithEffect((class_1309)this.orc, 3.0, OrcGroupEntity.class, class_1294.field_5909, 100, 3);
        AreaDamage.AreaCrackedGround((class_1309)this.orc, world, centerPos, 2);
        this.stompSound();
        this.generateParticles();
        if (this.target.method_17681() <= 2.0f && this.target.method_17682() <= 3.0f) {
            this.target.method_5762(0.0, 0.3, 0.0);
        }
    }

    private void attackNormal() {
        if (this.orc.method_6121((class_1297)this.target) && this.target.method_17681() <= 2.0f && (double)this.target.method_17682() <= 2.5) {
            this.target.method_5762(this.target.method_23317() - this.orc.method_23317(), 0.3, this.target.method_23321() - this.orc.method_23321());
        }
        this.orc.method_5783(ModSounds.MINO_HIT, 1.0f, 1.0f);
    }

    private void stopAttackTrig(int stopATimer) {
        this.stopAttackCD = stopATimer;
        this.orc.method_5996(class_5134.field_23719).method_6192((double)0.15f);
    }

    private void stopAttack() {
        if (this.stopAttackCD > 0) {
            --this.stopAttackCD;
        } else {
            this.orc.method_5996(class_5134.field_23719).method_6192(0.25);
        }
    }

    public boolean method_6264() {
        class_1309 target = this.orc.method_5968();
        return target != null && target.method_5805() && this.orc.method_6057((class_1297)target);
    }

    public void method_6269() {
        this.orc.method_19540(true);
        this.orc.setTrigger(false);
    }

    public void method_6270() {
        this.target = null;
        this.orc.setTrigger(false);
        this.orc.method_19540(false);
    }

    public boolean method_6266() {
        return this.target != null && this.target.method_5805();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        this.target = this.orc.method_5968();
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.stompCooldown = Math.max(this.stompCooldown - 1, 0);
        if (this.target == null) {
            return;
        }
        double distanceToTarget = this.orc.method_5739((class_1297)this.target);
        double d = this.getSquaredMaxAttackDistance(this.target);
        this.orc.method_5942().method_6335((class_1297)this.target, this.speed);
        this.stopAttack();
        if (distanceToTarget <= d) {
            this.orc.method_19540(false);
        } else {
            this.orc.method_19540(true);
        }
        if (this.attackCondition == 0) {
            this.randomizer = Math.random();
            if (this.randomizer < 0.5 && this.stompCooldown == 0) {
                this.orc.setAttackName("animation.minotaur.stomp_aoe");
                this.attackCondition = 4;
            } else if (this.randomizer < 0.2) {
                this.orc.setAttackName("animation.minotaur.holdme_attack");
                this.attackCondition = 3;
            } else if (this.randomizer < 0.5) {
                this.orc.setAttackName("animation.minotaur.hold_attack");
                this.attackCondition = 1;
            } else {
                this.orc.setAttackName("animation.minotaur.normal_attack");
                this.attackCondition = 2;
            }
        }
        if (this.attackCondition == 1) {
            if (distanceToTarget <= d && this.attackCooldown == 0) {
                this.attackCooldown = this.initialcooldown;
                this.orc.setTrigger(true);
                this.stopAttackTrig(this.holdattack);
            } else if (distanceToTarget <= d && this.attackCooldown == this.initialcooldown - this.holdattack) {
                this.attackNormal();
            } else if (this.attackCooldown == this.initialcooldown - this.holdattack - 5) {
                this.orc.setTrigger(false);
            } else if (this.attackCooldown <= 1) {
                this.attackCondition = 0;
            }
        }
        if (this.attackCondition == 2) {
            if (distanceToTarget <= d && this.attackCooldown == 0) {
                this.attackCooldown = this.initialcooldown;
                this.orc.setTrigger(true);
                this.stopAttackTrig(this.normalattack);
            } else if (distanceToTarget <= d && this.attackCooldown == this.initialcooldown - this.normalattack) {
                this.attackNormal();
            } else if (this.attackCooldown == this.initialcooldown - this.normalattack - 5) {
                this.orc.setTrigger(false);
            } else if (this.attackCooldown <= 1) {
                this.attackCondition = 0;
            }
        }
        if (this.attackCondition == 3) {
            if (distanceToTarget <= d && this.attackCooldown == 0) {
                this.attackCooldown = this.initialcooldown;
                this.orc.setTrigger(true);
                this.stopAttackTrig(this.holdmeattack);
            } else if (distanceToTarget <= d && this.attackCooldown == this.initialcooldown - this.holdmeattack) {
                this.attackNormal();
            } else if (this.attackCooldown == this.initialcooldown - this.holdmeattack - 5) {
                this.orc.setTrigger(false);
            } else if (this.attackCooldown <= 1) {
                this.attackCondition = 0;
            }
        }
        if (this.attackCondition == 4) {
            if (distanceToTarget <= d && this.attackCooldown == 0) {
                this.orc.method_5783(ModSounds.MINO_GROWL, 2.0f, 1.0f);
                this.attackCooldown = this.initialcooldown;
                this.orc.setTrigger(true);
                this.stopAttackTrig(this.stompaoe);
            } else if (this.attackCooldown == this.initialcooldown - this.stompaoe) {
                this.stompAttack();
                this.stompCooldown = 200;
            } else if (this.attackCooldown == this.initialcooldown - this.stompaoe - 5) {
                this.orc.setTrigger(false);
            } else if (this.attackCooldown <= 1) {
                this.attackCondition = 0;
            }
        }
    }

    protected double getSquaredMaxAttackDistance(class_1309 entity) {
        return 2.0f + entity.method_17681();
    }
}

