/*
 * Decompiled with CFR 0.152.
 */
package malfu.wandering_orc.entity.ai;

import java.util.EnumSet;
import malfu.wandering_orc.entity.custom.TrollEntity;
import malfu.wandering_orc.entity.projectiles.TrollThrowableEntity;
import malfu.wandering_orc.item.ModItems;
import malfu.wandering_orc.sound.ModSounds;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class TrollThrowGoal
extends class_1352 {
    private final TrollEntity orc;
    private class_1309 target;
    private int attackCooldown;
    private int fastAttackCD;
    private int condition = 0;
    private double speed;
    double randomizer;
    private int initialcooldown = 80;
    private int throwattackcd = 7;
    private static final float MAX_ATTACK_SPEED_INCREASE = 0.8f;
    private static final float ATTACK_SPEED_INCREASE_PER_ATTACK = 0.15f;
    private float currentAttackSpeedIncrease = 0.0f;

    public TrollThrowGoal(TrollEntity orc, double speed) {
        this.orc = orc;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405));
    }

    private void increaseAttackSpeed() {
        this.currentAttackSpeedIncrease += 0.15f;
        this.currentAttackSpeedIncrease = Math.min(this.currentAttackSpeedIncrease, 0.8f);
    }

    private void resetAttackSpeed() {
        this.currentAttackSpeedIncrease = 0.0f;
    }

    protected void getPunchSound() {
        this.orc.method_5783(ModSounds.ORC_ARCHER_PUNCH, 1.0f, 1.0f);
    }

    protected void punchAttack(class_1309 target) {
        if (this.orc.method_6121((class_1297)target)) {
            target.method_5762(target.method_23317() - this.orc.method_23317(), 0.2, target.method_23321() - this.orc.method_23321());
        }
        this.getPunchSound();
    }

    public boolean method_6264() {
        class_1309 target = this.orc.method_5968();
        return target != null && target.method_5805() && this.orc.method_6057((class_1297)target);
    }

    public void method_6269() {
        this.orc.setTrigger(false);
    }

    public void method_6270() {
        this.target = null;
        this.orc.setTrigger(false);
    }

    public boolean method_6266() {
        return this.target != null && this.target.method_5805();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        this.target = this.orc.method_5968();
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.fastAttackCD = Math.max(this.fastAttackCD - 1, 0);
        if (this.target == null) {
            return;
        }
        this.randomizer = Math.random();
        double distanceToTarget = this.orc.method_5739((class_1297)this.target);
        int attackIncreaseCD = (int)((float)this.initialcooldown * (1.0f - this.currentAttackSpeedIncrease));
        if (this.condition == 0 && this.currentAttackSpeedIncrease == 0.8f) {
            this.condition = 1;
            this.fastAttackCD = 180;
        } else if (this.condition == 1 && this.fastAttackCD <= 1) {
            this.condition = 0;
            this.resetAttackSpeed();
        }
        if (this.target != null) {
            this.orc.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        }
        if (distanceToTarget > 9.0) {
            class_11 path = this.orc.method_5942().method_6349((class_1297)this.target, 3);
            this.orc.method_5942().method_6334(path, this.speed);
        }
        if (distanceToTarget <= 9.0 && this.attackCooldown <= 0) {
            this.orc.method_5942().method_6335((class_1297)this.target, (double)0.1f);
            this.orc.setAttackName("animation.troll.attack2");
            this.attackCooldown = attackIncreaseCD;
            this.orc.setTrigger(true);
        } else if (distanceToTarget <= 9.0 && this.attackCooldown == attackIncreaseCD - this.throwattackcd) {
            class_1937 world = this.orc.method_37908();
            class_1799 arrowStack = this.orc.method_18808(new class_1799((class_1935)ModItems.TROLL_THROWABLE_ITEM));
            class_1665 arrow = this.createThrow(world, arrowStack);
            arrow.method_7432((class_1297)this.orc);
            double x = this.target.method_23317() - this.orc.method_23317();
            double y = this.target.method_23323(0.6) - arrow.method_23318();
            double z = this.target.method_23321() - this.orc.method_23321();
            double f = class_3532.method_15355((float)((float)(x * x + z * z)));
            arrow.method_7485(x, y + f * 0.1, z, 1.1f, 0.1f);
            world.method_8649((class_1297)arrow);
            this.orc.setTrigger(false);
            this.orc.method_5783(class_3417.field_14873, 1.0f, 1.0f);
        } else if (this.attackCooldown <= 1) {
            this.increaseAttackSpeed();
        }
    }

    private class_1665 createThrow(class_1937 world, class_1799 arrowStack) {
        TrollThrowableEntity trollThrow = new TrollThrowableEntity(world, (class_1309)this.orc, 5.0f);
        return trollThrow;
    }
}

