/*
 * Decompiled with CFR 0.152.
 */
package malfu.wandering_orc.entity.ai.wander;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import malfu.wandering_orc.entity.custom.MinotaurEntity;
import malfu.wandering_orc.entity.custom.OrcChampionEntity;
import malfu.wandering_orc.entity.custom.OrcGroupEntity;
import malfu.wandering_orc.entity.custom.OrcWarriorEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;

public class OrcFollowLeaderGoal
extends class_1352 {
    private final class_1308 mob;
    private int timer;

    public OrcFollowLeaderGoal(class_1308 mob) {
        this.mob = mob;
    }

    private void CountdownToFollow() {
        if (this.timer > 0) {
            --this.timer;
        } else {
            Random random = new Random();
            this.timer = 60 + random.nextInt(61);
        }
    }

    public boolean method_6264() {
        class_1309 leader = this.findNearestLeader(this.mob);
        return leader != null && this.mob.method_5739((class_1297)leader) > 15.0f;
    }

    public void method_6268() {
        class_1309 leader = this.findNearestLeader(this.mob);
        this.CountdownToFollow();
        if (leader != null && this.timer < 1 && !(this.mob.method_5739((class_1297)leader) < 4.0f)) {
            this.mob.method_5942().method_6337(leader.method_23317(), leader.method_23318(), leader.method_23321(), 1.0);
        }
    }

    private class_1309 findNearestLeader(class_1308 follower) {
        Class[] leaderClasses = new Class[]{OrcChampionEntity.class, OrcWarriorEntity.class, MinotaurEntity.class};
        class_1309 nearestLeader = null;
        int nearestLeaderPriority = Integer.MAX_VALUE;
        for (int i = 0; i < leaderClasses.length; ++i) {
            List potentialLeaders;
            Class leaderClass = leaderClasses[i];
            int currentPriority = i;
            if (currentPriority > nearestLeaderPriority || (potentialLeaders = follower.method_37908().method_8390(leaderClass, follower.method_5829().method_1014(42.0), entity -> this.isValidLeader((class_1309)entity, follower, currentPriority))).isEmpty()) continue;
            class_1309 closestLeader = potentialLeaders.stream().min(Comparator.comparingDouble(arg_0 -> ((class_1308)follower).method_5858(arg_0))).orElse(null);
            if (closestLeader == null) continue;
            nearestLeader = closestLeader;
            nearestLeaderPriority = currentPriority;
        }
        if (nearestLeader != null && nearestLeader instanceof OrcGroupEntity) {
            this.ensureSingleLeaderInArea((OrcGroupEntity)nearestLeader, follower.method_37908(), 42.0);
            this.ensureLeaderDoesNotFollowSameClass((OrcGroupEntity)nearestLeader);
        }
        return nearestLeader;
    }

    private boolean isValidLeader(class_1309 entity, class_1308 follower, int currentPriority) {
        int leaderPriority;
        OrcGroupEntity orcEntity;
        if (entity == follower) {
            return false;
        }
        return !(entity instanceof OrcGroupEntity) || (orcEntity = (OrcGroupEntity)entity).getLeader() == null || (leaderPriority = this.getPriorityForClass(orcEntity.getLeader().getClass())) < currentPriority;
    }

    private void ensureSingleLeaderInArea(OrcGroupEntity leader, class_1937 world, double radius) {
        Class<class_1309> leaderClass = ((Object)((Object)leader)).getClass().asSubclass(class_1309.class);
        List sameClassLeaders = world.method_8390(leaderClass, leader.method_5829().method_1014(radius), entity -> entity != leader && entity instanceof OrcGroupEntity);
        for (class_1309 sameClassLeader : sameClassLeaders) {
            OrcGroupEntity otherLeader;
            if (!(sameClassLeader instanceof OrcGroupEntity) || (otherLeader = (OrcGroupEntity)sameClassLeader).getLeader() != null) continue;
            otherLeader.setLeader((class_1309)leader);
        }
    }

    private void ensureLeaderDoesNotFollowSameClass(OrcGroupEntity leader) {
        class_1309 currentLeader = leader.getLeader();
        if (currentLeader != null && currentLeader.getClass() == ((Object)((Object)leader)).getClass()) {
            leader.setLeader(null);
        }
    }

    private int getPriorityForClass(Class<?> leaderClass) {
        if (leaderClass == OrcChampionEntity.class) {
            return 0;
        }
        if (leaderClass == OrcWarriorEntity.class) {
            return 1;
        }
        if (leaderClass == MinotaurEntity.class) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }
}

