#version 330 compatibility

#define MAX_DISTANCE 12 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]
#define FALLOFF_CURVE 0.0 // [-10.0 -9.0 -8.0 -7.0 -6.0 -5.0 -4.0 -3.0 -2.0 -1.0 0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]
//#define x depthValue
#define a actualMaxDistance
#define p FALLOFF_CURVE

uniform float far;

#define OFF 0
#define ON 1
#define DEPTH_OUTLINE OFF // [OFF ON]
#define PAPER_WORLD OFF // [OFF ON]
/////

#define THRESHOLD 0.0001 // [0.00001 0.0001 0.0002 0.001 0.002 0.01]
#define RIM_OFFECT 0.001 // [0.0001 0.0002 0.0005 0.001 0.002 0.003 0.004 0.005 0.01]
#define OUTLINE_COL 0.3 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9]
#define RAMP_VALUE 0.0001
#define SCREEN_VALUE 2000
uniform sampler2D depthtex0;

uniform sampler2D colortex0;

uniform float viewHeight;
uniform float viewWidth;

vec2 texelStep = 1.0 / vec2(viewWidth, viewHeight);
const float lumaThreshold = 0.5;
const float mulReduce = 1.0 / 8.0;
const float minReduce = 1.0 / 128.;
const float maxSpan = 8.0;

uniform mat4 gbufferProjectionInverse;
in vec2 texcoord;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 color;

float getRimIntensity(float depthOft1,float depthOft2,float depth)
{
   float depthDiffer1 = depthOft1 - depth;
   float depthDiffer2 = depthOft2 - depth;

   float rimIntensity1 = step(THRESHOLD,depthDiffer1);
   float rimIntensity2 = step(THRESHOLD,depthDiffer2);
   float rimIntensity = max(rimIntensity1,rimIntensity2);

   float isRamp = step(RAMP_VALUE,abs(depthDiffer1+depthDiffer2));

   return min(rimIntensity,isRamp);
}

float screenSpaceToViewSpace(float depth, mat4 projInv) {
	depth = depth * 2.0 - 1.0;
	return projInv[3].z / (projInv[2].w * depth + projInv[3].w);
}

float getDepthValue(float depth)
{
   if(DEPTH_OUTLINE == OFF)
   {
      return 1;
   }
   float viewDepth = screenSpaceToViewSpace(depth, gbufferProjectionInverse);
   float depthValue = max(-viewDepth, 0.0);
   const float actualMaxDistance = float(MAX_DISTANCE * 16.0);
   if(FALLOFF_CURVE != 0.0)
   {
      depthValue = (exp(p * (depthValue / a)) - 1.0) / (exp(p) - 1.0);
   } else 
   {
      depthValue /= actualMaxDistance;
   }
   depthValue = 1.0 - depthValue;
   return depthValue;
}


void main() 
{
	color = texture(colortex0, texcoord);
   float depth = texture(depthtex0, texcoord).r;
   float depthValue = getDepthValue(depth);

   float depthLeft = texture(depthtex0, vec2(texcoord.x + RIM_OFFECT / viewWidth * SCREEN_VALUE * depthValue ,texcoord.y)).r;
   float depthRight = texture(depthtex0, vec2(texcoord.x - RIM_OFFECT / viewWidth * SCREEN_VALUE * depthValue ,texcoord.y )).r;
   float depthUp = texture(depthtex0, vec2(texcoord.x,texcoord.y + RIM_OFFECT / viewHeight * SCREEN_VALUE * depthValue)).r;
   float depthDown = texture(depthtex0, vec2(texcoord.x,texcoord.y - RIM_OFFECT / viewHeight * SCREEN_VALUE * depthValue)).r;

   float rimIntensityV = getRimIntensity(depthLeft,depthRight,depth);

   float rimIntensityH = getRimIntensity(depthUp,depthDown,depth);

   float rimIntensity = max(rimIntensityV,rimIntensityH);

   vec4 outlineCol = vec4(OUTLINE_COL,OUTLINE_COL,OUTLINE_COL,1);

   if(rimIntensity == 1)
   {
      color = texture(colortex0, texcoord) * outlineCol;
      return;
   }

   if(PAPER_WORLD == ON)
   {
      color = vec4(depth,depth,depth,1);
      return;
   }

	vec3 rgbM = texture(colortex0, texcoord).rgb;

	// Sampling neighbour texels. Offsets are adapted to OpenGL texture coordinates. 
	vec3 rgbNW = textureOffset(colortex0, texcoord, ivec2(-1, 1)).rgb;
	vec3 rgbNE = textureOffset(colortex0, texcoord, ivec2(1, 1)).rgb;
	vec3 rgbSW = textureOffset(colortex0, texcoord, ivec2(-1, -1)).rgb;
	vec3 rgbSE = textureOffset(colortex0, texcoord, ivec2(1, -1)).rgb;

	// see http://en.wikipedia.org/wiki/Grayscale
	const vec3 toLuma = vec3(0.299, 0.587, 0.114);
	
	// Convert from RGB to luma.
	float lumaNW = dot(rgbNW, toLuma);
	float lumaNE = dot(rgbNE, toLuma);
	float lumaSW = dot(rgbSW, toLuma);
	float lumaSE = dot(rgbSE, toLuma);
	float lumaM = dot(rgbM, toLuma);

	// Gather minimum and maximum luma.
	float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
	
	// If contrast is lower than a maximum threshold ...
	if (lumaMax - lumaMin <= lumaMax * lumaThreshold)
	{
		// ... do no AA and return.
		color = vec4(rgbM, 1.0);
		//color = vec4(depth,depth,depth,1);
		return;
	}  
	
	// Sampling is done along the gradient.
	vec2 samplingDirection;	
	samplingDirection.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    samplingDirection.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
    
    // Sampling step distance depends on the luma: The brighter the sampled texels, the smaller the final sampling step direction.
    // This results, that brighter areas are less blurred/more sharper than dark areas.  
    float samplingDirectionReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * 0.25 * mulReduce, minReduce);

	// Factor for norming the sampling direction plus adding the brightness influence. 
	float minSamplingDirectionFactor = 1.0 / (min(abs(samplingDirection.x), abs(samplingDirection.y)) + samplingDirectionReduce);
    
    // Calculate final sampling direction vector by reducing, clamping to a range and finally adapting to the texture size. 
    samplingDirection = clamp(samplingDirection * minSamplingDirectionFactor, vec2(-maxSpan), vec2(maxSpan)) * texelStep;
	
	// Inner samples on the tab.
	vec3 rgbSampleNeg = texture(colortex0, texcoord + samplingDirection * (1.0/3.0 - 0.5)).rgb;
	vec3 rgbSamplePos = texture(colortex0, texcoord + samplingDirection * (2.0/3.0 - 0.5)).rgb;

	vec3 rgbTwoTab = (rgbSamplePos + rgbSampleNeg) * 0.5;  

	// Outer samples on the tab.
	vec3 rgbSampleNegOuter = texture(colortex0, texcoord + samplingDirection * (0.0/3.0 - 0.5)).rgb;
	vec3 rgbSamplePosOuter = texture(colortex0, texcoord + samplingDirection * (3.0/3.0 - 0.5)).rgb;
	
	vec3 rgbFourTab = (rgbSamplePosOuter + rgbSampleNegOuter) * 0.25 + rgbTwoTab * 0.5;   
	
	// Calculate luma for checking against the minimum and maximum value.
	float lumaFourTab = dot(rgbFourTab, toLuma);
	
	// Are outer samples of the tab beyond the edge ... 
	if (lumaFourTab < lumaMin || lumaFourTab > lumaMax)
	{
		// ... yes, so use only two samples.
		color = vec4(rgbTwoTab, 1.0); 
	}
	else
	{
		// ... no, so use four samples. 
		color = vec4(rgbFourTab, 1.0);
	}
   //color = vec4(depth,depth,depth,1);
}

//LZX vscode 2025/03/24

//||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
//||||--==||||||||||||||||------==||||||||||----------==||||
//||||--==||||||||||||||------------==||||||------------==||
//||||--==|||||||||||||---==||||----==||||||--==||||----==||
//||||--==|||||||||||||---==||||||||||||||||--------------||
//||||--==|||||||||||||---==||||----==||||||----------==||||
//||||------------==||||------------==||||||--==||||||||||||
//||||------------==||||||------==||||||||||--==||||||||||||
//||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
//|||||||||||||||||LZX.Celluloid.Project||||||||||||||||||||