/*
 * Decompiled with CFR 0.152.
 */
package crazynessawakened.entity;

import crazynessawakened.entity.WaterChargeEntity;
import crazynessawakened.init.CrazinessAwakenedModEntities;
import crazynessawakened.procedures.WaterDragonEntityDiesProcedure;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WaterDragonEntity
extends TamableAnimal
implements RangedAttackMob,
GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(WaterDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(WaterDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(WaterDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public WaterDragonEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WaterDragonEntity>)((EntityType)CrazinessAwakenedModEntities.WATER_DRAGON.get()), world);
    }

    public WaterDragonEntity(EntityType<WaterDragonEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 23;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (WaterDragonEntity.this.m_20069_()) {
                    WaterDragonEntity.this.m_20256_(WaterDragonEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !WaterDragonEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - WaterDragonEntity.this.m_20185_();
                    double dy = this.f_24976_ - WaterDragonEntity.this.m_20186_();
                    double dz = this.f_24977_ - WaterDragonEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * WaterDragonEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    WaterDragonEntity.this.m_146922_(this.m_24991_(WaterDragonEntity.this.m_146908_(), f, 10.0f));
                    WaterDragonEntity.this.f_20883_ = WaterDragonEntity.this.m_146908_();
                    WaterDragonEntity.this.f_20885_ = WaterDragonEntity.this.m_146908_();
                    if (WaterDragonEntity.this.m_20069_()) {
                        WaterDragonEntity.this.m_7910_((float)WaterDragonEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        WaterDragonEntity.this.m_146926_(this.m_24991_(WaterDragonEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(WaterDragonEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        WaterDragonEntity.this.m_21564_(f3 * f1);
                        WaterDragonEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        WaterDragonEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    WaterDragonEntity.this.m_7910_(0.0f);
                    WaterDragonEntity.this.m_21567_(0.0f);
                    WaterDragonEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"waterrrrr");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.7f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 80, 25.0f){

            @Override
            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        WaterDragonEntityDiesProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.2f);
    }

    public void m_6504_(LivingEntity target, float flval) {
        WaterChargeEntity.shoot((LivingEntity)this, target);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        WaterDragonEntity retval = (WaterDragonEntity)((EntityType)CrazinessAwakenedModEntities.WATER_DRAGON.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42526_).contains(stack.m_41720_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CrazinessAwakenedModEntities.WATER_DRAGON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 150.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22281_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 23.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.m_20072_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class RangedAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public RangedAttackGoal(RangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_) {
            this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
        }

        public RangedAttackGoal(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
            if (!(p_25773_ instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackMob = p_25773_;
            this.mob = (Mob)p_25773_;
            this.speedModifier = p_25774_;
            this.attackIntervalMin = p_25775_;
            this.attackIntervalMax = p_25776_;
            this.attackRadius = p_25777_;
            this.attackRadiusSqr = p_25777_ * p_25777_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            ((WaterDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    ((WaterDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
                    return;
                }
                ((WaterDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)true);
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.m_6504_(this.target, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            } else {
                ((WaterDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
            }
        }
    }
}

