/*
 * Decompiled with CFR 0.152.
 */
package org.ferrum.lockItems.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.ferrum.lockItems.LockItems;
import org.ferrum.lockItems.utils.ConfigManager;
import org.ferrum.lockItems.utils.DataManager;

public class LockCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (DataManager.hasDataFromItem(itemInHand, LockItems.lock_owner)) {
                player.sendMessage(ConfigManager.getStringByKey("item_already_locked", (OfflinePlayer)player));
                return true;
            }
            if (LockItems.LockableItems.contains(itemInHand.getType())) {
                ItemMeta meta = itemInHand.getItemMeta();
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                String item_lore = ConfigManager.getStringByKey("item_lore", (OfflinePlayer)player).replace("{Player}", player.getName());
                if (!item_lore.isEmpty() && lore != null) {
                    lore.add(String.valueOf(ChatColor.RESET) + item_lore);
                }
                meta.setLore(lore);
                itemInHand.setItemMeta(meta);
                DataManager.setDataToItem(itemInHand, LockItems.lock_owner, player.getUniqueId().toString());
                DataManager.setDataToItem(itemInHand, LockItems.lock_text, item_lore);
                player.sendMessage(ConfigManager.getStringByKey("item_successfully_locked", (OfflinePlayer)player));
                return true;
            }
            if (itemInHand.getType().isAir()) {
                player.sendMessage(ConfigManager.getStringByKey("attempt_lock_empty_hand", (OfflinePlayer)player));
                return true;
            }
            player.sendMessage(ConfigManager.getStringByKey("attempt_lock_item_not_in_list", (OfflinePlayer)player));
            return true;
        }
        sender.sendMessage(ConfigManager.getStringByKey("command_sender_not_player"));
        return true;
    }
}

