/*
 * Decompiled with CFR 0.152.
 */
package org.ferrum.lockItems.commands;

import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.ferrum.lockItems.LockItems;
import org.ferrum.lockItems.utils.ConfigManager;
import org.ferrum.lockItems.utils.DataManager;
import org.jetbrains.annotations.NotNull;

public class UnLockCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand.getType().isAir()) {
                player.sendMessage(ConfigManager.getStringByKey("attempt_unlock_empty_hand", (OfflinePlayer)player));
                return true;
            }
            if (!LockItems.LockableItems.contains(itemInHand.getType())) {
                player.sendMessage(ConfigManager.getStringByKey("attempt_unlock_item_not_in_list", (OfflinePlayer)player));
                return true;
            }
            String uuidOwner = DataManager.getDataFromItem(itemInHand, LockItems.lock_owner);
            if (uuidOwner == null) {
                player.sendMessage(ConfigManager.getStringByKey("item_not_locked", (OfflinePlayer)player));
                return true;
            }
            if (!uuidOwner.equals(player.getUniqueId().toString())) {
                player.sendMessage(ConfigManager.getStringByKey("attempt_unlock_item_not_owner", (OfflinePlayer)player));
                return true;
            }
            ItemMeta meta = itemInHand.getItemMeta();
            ArrayList lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList();
            }
            if (DataManager.hasDataFromItem(itemInHand, LockItems.lock_text)) {
                lore.remove(DataManager.getDataFromItem(itemInHand, LockItems.lock_text));
            } else {
                lore.remove(ConfigManager.getStringByKey("item_lore").replace("{Player}", player.getName()));
            }
            meta.setLore(lore);
            itemInHand.setItemMeta(meta);
            DataManager.removeDataFromItem(itemInHand, LockItems.lock_owner);
            DataManager.removeDataFromItem(itemInHand, LockItems.lock_text);
            player.sendMessage(ConfigManager.getStringByKey("item_successfully_unlocked", (OfflinePlayer)player));
        } else {
            sender.sendMessage(ConfigManager.getStringByKey("command_sender_not_player"));
        }
        return true;
    }
}

