/*
 * Decompiled with CFR 0.152.
 */
package org.ferrum.lockItems.listeners;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.block.Crafter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.ferrum.lockItems.LockItems;
import org.ferrum.lockItems.utils.ConfigManager;
import org.ferrum.lockItems.utils.DataManager;

public class CraftListener
implements Listener {
    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        for (ItemStack item : event.getInventory().getMatrix()) {
            if (!this.notOwner(item, event.getWhoClicked().getUniqueId())) continue;
            event.setCancelled(true);
            event.getWhoClicked().sendMessage(ConfigManager.getStringByKey("attempt_craft_locked_item", DataManager.getItemOwner(item)));
        }
    }

    @EventHandler
    public void onCrafterCraft(CrafterCraftEvent event) {
        Inventory inventory = ((Crafter)event.getBlock().getState()).getInventory();
        for (ItemStack item : inventory) {
            if (!DataManager.hasDataFromItem(item, LockItems.lock_owner)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onCartographyTableUse(InventoryClickEvent event) {
        ItemStack item;
        Inventory inv = event.getClickedInventory();
        if (inv != null && inv.getType() == InventoryType.CARTOGRAPHY && event.getSlot() == 2 && this.notOwner(item = event.getCurrentItem(), event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
            event.getWhoClicked().sendMessage(ConfigManager.getStringByKey("attempt_craft_locked_item", DataManager.getItemOwner(item)));
        }
    }

    private boolean notOwner(ItemStack item, UUID uuid) {
        return DataManager.hasDataFromItem(item, LockItems.lock_owner) && !Objects.equals(DataManager.getDataFromItem(item, LockItems.lock_owner), uuid.toString());
    }
}

