/*
 * Decompiled with CFR 0.152.
 */
package org.ferrum.lockItems.utils;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.ferrum.lockItems.LockItems;

public class ConfigManager {
    private static FileConfiguration config;
    private static FileConfiguration messages;
    private static boolean PlaceholderAPI_isLoad;

    public static void init() {
        ConfigManager.loadConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            PlaceholderAPI_isLoad = true;
        } else {
            LockItems.plugin.getLogger().log(Level.INFO, "PlaceholderAPI not found!");
        }
    }

    public static void loadConfig() {
        File configFile = new File(LockItems.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            LockItems.plugin.saveResource("config.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        File languageFile = new File(String.valueOf(LockItems.plugin.getDataFolder()) + "/language/" + config.getString("language", "en") + ".yml");
        if (!languageFile.exists()) {
            try {
                LockItems.plugin.saveResource("language/" + config.getString("language", "en") + ".yml", false);
            }
            catch (IllegalArgumentException e) {
                LockItems.plugin.getLogger().warning(config.getString("language") + ".yml not found!");
            }
        }
        messages = YamlConfiguration.loadConfiguration((File)languageFile);
        ConfigManager.updateLockItems();
    }

    public static String getStringByKey(String key, OfflinePlayer player) {
        String string = messages.getString(key, "text." + key);
        string = player != null && player.getName() != null ? string.replace("{Player}", player.getName()) : string.replace("{Player}", "???");
        if (PlaceholderAPI_isLoad) {
            string = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public static String getStringByKey(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)messages.getString(key, "text." + key));
    }

    public static void updateLockItems() {
        LockItems.LockableItems.clear();
        List LockItemsList = config.getStringList("ItemCanBeLock");
        List LockItemsTagList = config.getStringList("ItemTagCanBeLock");
        for (String material : LockItemsList) {
            LockItems.LockableItems.add(Material.getMaterial((String)material));
        }
        for (String lockItemTagName : LockItemsTagList) {
            Tag itemsFoTag = Bukkit.getTag((String)"items", (NamespacedKey)NamespacedKey.minecraft((String)lockItemTagName), Material.class);
            if (itemsFoTag == null) continue;
            LockItems.LockableItems.addAll(itemsFoTag.getValues());
        }
        LockItems.plugin.getLogger().log(Level.INFO, "Register " + LockItems.LockableItems.size() + " items");
    }
}

