/*
 * Decompiled with CFR 0.152.
 */
package org.ferrum.lockItems.utils;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.ferrum.lockItems.LockItems;

public class DataManager {
    public static void setDataToItem(ItemStack item, NamespacedKey key, String data) {
        if (!LockItems.LockableItems.contains(item.getType())) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)data);
        item.setItemMeta(meta);
    }

    public static String getDataFromItem(ItemStack item, NamespacedKey key) {
        if (!LockItems.LockableItems.contains(item.getType())) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        return (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
    }

    public static boolean hasDataFromItem(ItemStack item, NamespacedKey key) {
        if (item == null) {
            return false;
        }
        if (!LockItems.LockableItems.contains(item.getType())) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }

    public static void removeDataFromItem(ItemStack item, NamespacedKey key) {
        if (!LockItems.LockableItems.contains(item.getType())) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().remove(key);
        item.setItemMeta(meta);
    }

    public static OfflinePlayer getItemOwner(ItemStack item) {
        String uuid = DataManager.getDataFromItem(item, LockItems.lock_owner);
        if (uuid == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
    }
}

