/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.behavior;

import com.cobblemon.mod.common.CobblemonActivities;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonMemories;
import com.dtteam.dtcobblemon.leaves.DynamicSaccharineLeavesBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlaceHoneyReplacedBehavior
extends Behavior<LivingEntity> {
    private int successfulPollinationTicks = 0;
    private int lastSoundPlayedTick = 0;
    private Vec3 hoverPos = null;

    public PlaceHoneyReplacedBehavior(Behavior<LivingEntity> original) {
        super(original.entryCondition, original.minDuration, original.maxDuration);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity owner) {
        if (level.isNight() || level.isRaining()) {
            return false;
        }
        boolean hasNectar = owner.getBrain().getMemory(CobblemonMemories.HAS_NECTAR).orElse(false);
        if (!hasNectar) {
            return false;
        }
        Optional opt = owner.getBrain().getMemory(CobblemonMemories.NEARBY_SACC_LEAVES);
        if (opt.isEmpty()) {
            return false;
        }
        BlockPos pos = (BlockPos)opt.get();
        if (!PlaceHoneyReplacedBehavior.isValidLeaves(level, pos)) {
            return false;
        }
        return Vec3.atCenterOf((Vec3i)pos).distanceTo(owner.position()) <= 1.2;
    }

    private static boolean isValidLeaves(ServerLevel level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        return block == CobblemonBlocks.SACCHARINE_LEAVES || block instanceof DynamicSaccharineLeavesBlock;
    }

    protected boolean canStillUse(ServerLevel level, LivingEntity owner, long gameTime) {
        return this.checkExtraStartConditions(level, owner) && owner.getBrain().activeActivities.contains(CobblemonActivities.POKEMON_POLLINATION);
    }

    protected void start(ServerLevel level, LivingEntity owner, long gameTime) {
        super.start(level, owner, gameTime);
        this.hoverPos = null;
    }

    protected void tick(ServerLevel level, LivingEntity entity, long gameTime) {
        boolean randomMove;
        ++this.successfulPollinationTicks;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob owner = (Mob)entity;
        if (owner.getRandom().nextFloat() < 0.05f && this.successfulPollinationTicks > this.lastSoundPlayedTick + 60) {
            this.lastSoundPlayedTick = this.successfulPollinationTicks;
            owner.playSound(SoundEvents.BEEHIVE_DRIP, 1.0f, 1.0f);
        }
        BlockPos leavesPos = owner.getBrain().getMemory(CobblemonMemories.NEARBY_SACC_LEAVES).orElse(null);
        boolean reachedHover = this.hoverPos == null || owner.position().distanceTo(this.hoverPos) <= 0.1;
        boolean bl = randomMove = owner.getRandom().nextInt(40) == 0;
        if (reachedHover && randomMove) {
            if (this.hoverPos == null) {
                Vec3 vec3 = this.hoverPos = leavesPos != null ? Vec3.atBottomCenterOf((Vec3i)leavesPos).add(0.0, 0.4, 0.0) : null;
            }
            if (leavesPos != null) {
                RandomSource rnd = owner.getRandom();
                this.hoverPos = Vec3.atBottomCenterOf((Vec3i)leavesPos).add((rnd.nextDouble() * 2.0 - 1.0) * 0.2, 0.3 + (rnd.nextDouble() * 2.0 - 1.0) * 0.14285714285714285, (rnd.nextDouble() * 2.0 - 1.0) * 0.2);
                owner.getMoveControl().setWantedPosition(this.hoverPos.x(), this.hoverPos.y(), this.hoverPos.z(), 0.35);
                owner.getLookControl().setLookAt(Vec3.atBottomCenterOf((Vec3i)leavesPos).add(0.0, 0.5, 0.0));
            }
        } else if (!reachedHover && this.hoverPos != null) {
            owner.getMoveControl().setWantedPosition(this.hoverPos.x(), this.hoverPos.y(), this.hoverPos.z(), 0.35);
        }
    }

    protected void stop(ServerLevel level, LivingEntity owner, long gameTime) {
        int age;
        BlockState state;
        BlockPos blockPos;
        if (this.successfulPollinationTicks > 250 && (blockPos = (BlockPos)owner.getBrain().getMemory(CobblemonMemories.NEARBY_SACC_LEAVES).orElse(null)) != null && (state = level.getBlockState(blockPos)).hasProperty((Property)BlockStateProperties.AGE_2) && (age = ((Integer)state.getValue((Property)BlockStateProperties.AGE_2)).intValue()) < 2) {
            owner.getBrain().eraseMemory(CobblemonMemories.HAS_NECTAR);
            BlockState newState = (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(age + 1));
            level.setBlock(blockPos, newState, 3);
        }
        this.successfulPollinationTicks = 0;
        owner.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

