/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.fruit;

import com.dtteam.dynamictrees.block.DynamicBlockProperties;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class ApricornFruitStateGenerator
implements Generator<DTBlockStateProvider, Fruit> {
    public void generate(DTBlockStateProvider provider, Fruit input, Generator.Dependencies dependencies) {
        FruitBlock block = input.getBlock();
        provider.getVariantBuilder((Block)block).forAllStates(state -> {
            int maxAge = block.getMaxAge();
            IntegerProperty ageProperty = DynamicBlockProperties.getOrCreateAge((int)maxAge);
            int age = (Integer)state.getValue((Property)ageProperty);
            if (age == maxAge) {
                BlockModelBuilder builder = (BlockModelBuilder)provider.models().withExistingParent(this.getName((Block)block), provider.modLoc("apricorn_stage_" + age));
                ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ITEM.getKey((Object)input.getItemStack().getItem()).getNamespace(), (String)("block/crops/" + this.getName((Block)block)));
                builder = (BlockModelBuilder)builder.texture("apricorn", texture);
                return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)provider.models().getExistingFile(provider.modLoc("apricorn_stage_" + age))).build();
        });
    }

    public Generator.Dependencies gatherDependencies(Fruit input) {
        return new Generator.Dependencies();
    }

    protected String getName(Block item) {
        return BuiltInRegistries.BLOCK.getKey((Object)item).getPath();
    }
}

