/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.genfeature;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.BeeNestGenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SaccharineBeeNestGenFeature
extends BeeNestGenFeature {
    public static final ConfigurationProperty<Float> COMBEE_PROBABILITY = ConfigurationProperty.floatProperty((String)"combee_probability");
    public static final ConfigurationProperty<Integer> COMBEE_MIN_LEVEL = ConfigurationProperty.integer((String)"combee_min_level");
    public static final ConfigurationProperty<Integer> COMBEE_MAX_LEVEL = ConfigurationProperty.integer((String)"combee_max_level");
    private static final String PokemonArgs = "combee";
    public static double BeeNestWorldGenChance = 0.5;
    public static double BeeNestGrowChance = 0.1;

    public SaccharineBeeNestGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{COMBEE_PROBABILITY, COMBEE_MIN_LEVEL, COMBEE_MAX_LEVEL});
    }

    @NotNull
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(NEST_BLOCK, (Object)Blocks.BEE_NEST)).with(MAX_HEIGHT, (Object)32)).with(COMBEE_PROBABILITY, (Object)Float.valueOf(0.5f))).with(COMBEE_MIN_LEVEL, (Object)5)).with(COMBEE_MAX_LEVEL, (Object)15)).with(CAN_GROW_PREDICATE, (world, pos) -> {
            if ((double)world.getRandom().nextFloat() > BeeNestGrowChance) {
                return false;
            }
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.below().north(2).west(2), (BlockPos)pos.above().south(2).east(2))) {
                if (!world.getBlockState(blockpos).is(BlockTags.FLOWERS)) continue;
                return true;
            }
            return false;
        })).with(WORLD_GEN_CHANCE_FUNCTION, (world, pos) -> BeeNestWorldGenChance)).with(MAX_COUNT, (Object)1);
    }

    protected boolean placeBeeNestInValidPlace(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, boolean worldGen, RandomSource random) {
        int treeHeight;
        Block nestBlock = (Block)configuration.get(NEST_BLOCK);
        if (this.nestAlreadyPresent(world, nestBlock, rootPos, treeHeight = this.getTreeHeight(world, rootPos, (Integer)configuration.get(MAX_HEIGHT)))) {
            return false;
        }
        List validSpaces = this.findBranchPits(configuration, world, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (!validSpaces.isEmpty()) {
            Pair chosenSpace = (Pair)validSpaces.get(world.getRandom().nextInt(validSpaces.size()));
            Direction chosenDir = (Direction)((List)chosenSpace.getValue()).get(world.getRandom().nextInt(((List)chosenSpace.getValue()).size()));
            return this.placeBeeNestWithBees(configuration, world, nestBlock, (BlockPos)chosenSpace.getKey(), chosenDir, worldGen, random);
        }
        return false;
    }

    private boolean placeBeeNestWithBees(GenFeatureConfiguration configuration, LevelAccessor world, Block nestBlock, BlockPos pos, Direction faceDir, boolean worldGen, RandomSource random) {
        BlockState nestState = nestBlock.defaultBlockState();
        if (nestState.hasProperty((Property)BeehiveBlock.FACING)) {
            nestState = (BlockState)nestState.setValue((Property)BeehiveBlock.FACING, (Comparable)faceDir);
        }
        float combeeChance = ((Float)configuration.get(COMBEE_PROBABILITY)).floatValue();
        int combeeMinLevel = (Integer)configuration.get(COMBEE_MIN_LEVEL);
        int combeeMaxLevel = (Integer)configuration.get(COMBEE_MAX_LEVEL);
        world.setBlock(pos, nestState, 3);
        world.getBlockEntity(pos, BlockEntityType.BEEHIVE).ifPresent(blockEntity -> {
            int j = 2 + random.nextInt(2);
            float isCombee = random.nextFloat();
            for (int k = 0; k < j; ++k) {
                if (isCombee < combeeChance && world instanceof WorldGenRegion) {
                    WorldGenRegion level = (WorldGenRegion)world;
                    String properties = "combee lvl=" + (combeeMinLevel + random.nextInt(combeeMaxLevel - combeeMinLevel + 1));
                    PokemonProperties pokemon = PokemonProperties.Companion.parse(properties);
                    PokemonEntity entity = pokemon.createEntity((Level)level.getLevel());
                    blockEntity.addOccupant((Entity)entity);
                    continue;
                }
                SaccharineBeeNestGenFeature.storeBee((RandomSource)random, (BeehiveBlockEntity)blockEntity);
            }
        });
        return true;
    }
}

