/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.tree;

import com.dtteam.dtcobblemon.DynamicTreesCobblemon;
import com.dtteam.dtcobblemon.branch.SaccharineBranchBlock;
import com.dtteam.dtcobblemon.branch.SlatheredSaccharineBranchBlock;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.builder.BranchLoaderBuilder;
import com.dtteam.dynamictrees.data.generator.BranchStateGenerator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class SaccharineFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(SaccharineFamily::new);
    protected int minimumRadiusForSlathering = 5;
    protected Supplier<BranchBlock> slatheredBranch;
    protected Block primitiveSlatheredLog;
    protected final MutableLazyValue<SlatheredBranchStateGenerator> slatheredBranchStateGenerator = MutableLazyValue.supplied(SlatheredBranchStateGenerator::new);

    public SaccharineFamily(ResourceLocation name) {
        super(name);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.slatheredBranch = this.setupBranch(this.createSlatheredBranch(this.getBranchName("slathered_")), true);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        SaccharineBranchBlock branch = new SaccharineBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createSlatheredBranch(ResourceLocation name) {
        return RegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createSlatheredBranchBlock(name));
    }

    protected BranchBlock createSlatheredBranchBlock(ResourceLocation name) {
        SlatheredSaccharineBranchBlock branch = new SlatheredSaccharineBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    public Family setPrimitiveLog(Block primitiveLog) {
        this.slatheredBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)primitiveLog)});
        return super.setPrimitiveLog(primitiveLog);
    }

    public void setPrimitiveSlatheredLog(Block primitiveLog) {
        this.primitiveSlatheredLog = primitiveLog;
    }

    public Optional<BranchBlock> getSlatheredBranch() {
        return Optionals.ofBlock((Block)this.slatheredBranch.get());
    }

    public Optional<Block> getPrimitiveSlatheredLog() {
        return Optionals.ofBlock((Block)this.primitiveSlatheredLog);
    }

    public int getMinimumRadiusForSlathering() {
        return this.minimumRadiusForSlathering;
    }

    public void setMinimumRadiusForSlathering(int minimumRadiusForSlathering) {
        this.minimumRadiusForSlathering = minimumRadiusForSlathering;
    }

    public void generateStateData(DTDataProvider.BlockState provider) {
        super.generateStateData(provider);
        ((SlatheredBranchStateGenerator)((Object)this.slatheredBranchStateGenerator.get())).generate((DTDataProvider)provider, (Object)this);
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation, Block sourceBlock) {
        Optional<Block> primSlathered = this.getPrimitiveSlatheredLog();
        if (primSlathered.isPresent() && primSlathered.get() == sourceBlock) {
            ResourceLocation bark = primitiveLogLocation;
            ResourceLocation rings = ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_top");
            ResourceLocation slathered = ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_slathered");
            if (this.textureOverrides.containsKey("branch")) {
                bark = (ResourceLocation)this.textureOverrides.get("branch");
            }
            if (this.textureOverrides.containsKey("branch_top")) {
                rings = (ResourceLocation)this.textureOverrides.get("branch_top");
            }
            if (this.textureOverrides.containsKey("slathered_branch")) {
                slathered = (ResourceLocation)this.textureOverrides.get("slathered_branch");
            }
            textureConsumer.accept("bark", bark);
            textureConsumer.accept("rings", rings);
            textureConsumer.accept("slathered", slathered);
            return;
        }
        super.addBranchTextures(textureConsumer, primitiveLogLocation, sourceBlock);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getSlatheredBranch().ifPresent(branch -> {
            this.tierTag(this.getDefaultBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.add(branch));
            this.defaultBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add(branch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey(branch));
                }
            });
        });
        super.addGeneratedBlockTags(tagAppender);
    }

    public static class SlatheredBranchStateGenerator
    extends BranchStateGenerator {
        public static final Generator.DependencyKey<Block> PRIMITIVE_SLATHERED_LOG = new Generator.DependencyKey("primitive_slathered_log");

        public void generate(DTDataProvider.BlockState prov, Family input, Generator.Dependencies dependencies) {
            if (prov instanceof DTBlockStateProvider) {
                DTBlockStateProvider provider = (DTBlockStateProvider)prov;
                BranchBlock branch = (BranchBlock)dependencies.get(BRANCH);
                BranchLoaderBuilder builder = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)branch)).getPath())).customLoader((BiFunction)BranchLoaderBuilder.branchBuilders.get(DynamicTreesCobblemon.SLATHERED_BRANCH));
                Block block = (Block)dependencies.get(PRIMITIVE_LOG);
                Block slathered_block = (Block)dependencies.get(PRIMITIVE_SLATHERED_LOG);
                input.addBranchTextures((arg_0, arg_1) -> ((BranchLoaderBuilder)builder).texture(arg_0, arg_1), provider.block(BuiltInRegistries.BLOCK.getKey((Object)block)), block);
                input.addBranchTextures((arg_0, arg_1) -> ((BranchLoaderBuilder)builder).texture(arg_0, arg_1), provider.block(BuiltInRegistries.BLOCK.getKey((Object)slathered_block)), slathered_block);
                provider.simpleBlock((Block)branch, (ModelFile)builder.end());
            }
        }

        @NotNull
        public Generator.Dependencies gatherDependencies(@NotNull Family input) {
            if (input instanceof SaccharineFamily) {
                SaccharineFamily castedInput = (SaccharineFamily)input;
                return new Generator.Dependencies().append(BRANCH, castedInput.getSlatheredBranch()).append(PRIMITIVE_SLATHERED_LOG, castedInput.getPrimitiveSlatheredLog()).append(PRIMITIVE_LOG, castedInput.getPrimitiveLog());
            }
            return super.gatherDependencies(input);
        }
    }
}

