/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.branch;

import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.entity.MoLangScriptingEntity;
import com.dtteam.dtcobblemon.branch.SlatheredSaccharineBranchBlock;
import com.dtteam.dtcobblemon.tree.SaccharineFamily;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaccharineBranchBlock
extends BasicBranchBlock {
    public SaccharineBranchBlock(ResourceLocation name, BlockBehaviour.Properties blockProperties) {
        super(name, blockProperties);
    }

    public static void changeLogType(LevelAccessor level, BlockPos pos, BranchBlock branch, int radius, Direction honeyDirection) {
        SaccharineBranchBlock.changeLogType(level, pos, branch, radius, honeyDirection, null, null);
    }

    public static void changeLogType(LevelAccessor level, BlockPos pos, BranchBlock branch, int radius, Direction honeyDirection, @Nullable Player player, @Nullable ItemStack itemStack) {
        if (branch instanceof SlatheredSaccharineBranchBlock) {
            SlatheredSaccharineBranchBlock slatheredBranch = (SlatheredSaccharineBranchBlock)branch;
            slatheredBranch.setRadius(level, pos, radius, 3, honeyDirection);
        } else {
            branch.setRadius(level, pos, radius, null, 3);
        }
        if (player == null || player.hasInfiniteMaterials() || itemStack == null) {
            return;
        }
        itemStack.consume(1, (LivingEntity)player);
        ItemStack glassBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        if (!player.addItem(glassBottle)) {
            player.drop(glassBottle, false);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SlatheredSaccharineBranchBlock branch;
        int rad;
        Direction blockFace;
        ItemStack itemStack;
        block5: {
            block4: {
                BranchBlock branchBlock;
                Family family;
                itemStack = player.getItemInHand(hand);
                blockFace = hitResult.getDirection();
                if (level.isClientSide() || blockFace == Direction.UP || blockFace == Direction.DOWN || !itemStack.is(Items.HONEY_BOTTLE) || level.getFluidState(pos.relative(blockFace)).getAmount() > 3 || ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || TreeHelper.isBranch((BlockState)level.getBlockState(pos.relative(blockFace))) || !((family = this.getFamily()) instanceof SaccharineFamily)) {
                    return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
                }
                SaccharineFamily saccharineFamily = (SaccharineFamily)family;
                rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos);
                Optional<BranchBlock> branchOpt = saccharineFamily.getSlatheredBranch();
                if (branchOpt.isEmpty() || !((branchBlock = branchOpt.get()) instanceof SlatheredSaccharineBranchBlock)) break block4;
                branch = (SlatheredSaccharineBranchBlock)branchBlock;
                if (rad > 0 && rad >= saccharineFamily.getMinimumRadiusForSlathering()) break block5;
            }
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        SaccharineBranchBlock.changeLogType((LevelAccessor)level, pos, (BranchBlock)branch, rad, blockFace, player, itemStack);
        level.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            MoLangScriptingEntity moEntity;
            Entity entity;
            EntityCollisionContext eContext = (EntityCollisionContext)context;
            if (TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos) < 8 && (entity = eContext.getEntity()) instanceof MoLangScriptingEntity && ((MoValue)(moEntity = (MoLangScriptingEntity)entity).getConfig().getMap().getOrDefault("can_path_through_sacc_leaves", DoubleValue.ZERO)).asDouble() == 1.0) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(state, level, pos, context);
    }
}

