/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.mixin;

import com.cobblemon.mod.common.api.spawning.influence.SaccharineLogSlatheredInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpatialSpawningZoneInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawningZoneInfluence;
import com.cobblemon.mod.common.api.spawning.prospecting.SaccharineLogSlatheredDetector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.dtteam.dtcobblemon.init.DTCobblemonPoiTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SaccharineLogSlatheredDetector.class})
public class SaccharineSlatheredDetector {
    @Final
    @Shadow
    public static int RANGE;

    @Inject(method={"detectFromInput"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void detectFromInput(Spawner spawner, SpawningZoneInput input, CallbackInfoReturnable<List<SpawningZoneInfluence>> cir) {
        List listOfInfluences = (List)cir.getReturnValue();
        ServerLevel world = input.getWorld();
        int searchRange = RANGE + (int)Math.ceil(Math.sqrt(Math.pow(input.getLength(), 2.0) + Math.pow(input.getWidth(), 2.0)));
        BlockPos centerPos = BlockPos.containing((Position)input.getCenter());
        List honeyLogPositions = world.getPoiManager().findAll(holder -> holder.is(DTCobblemonPoiTypes.SACCHARINE_BRANCH_SLATHERED.getKey()), pos -> true, centerPos, searchRange, PoiManager.Occupancy.ANY).toList();
        for (BlockPos pos2 : honeyLogPositions) {
            listOfInfluences.add(new SpatialSpawningZoneInfluence(pos2, (float)RANGE, (SpawningInfluence)new SaccharineLogSlatheredInfluence(pos2)));
        }
        cir.setReturnValue((Object)listOfInfluences);
    }
}

