/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.leaves;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicSaccharineLeavesBlock
extends DynamicLeavesBlock {
    public static final IntegerProperty HONEY = BlockStateProperties.AGE_2;
    public static final int MAX_HONEY = 2;
    public static final int MIN_HONEY = 0;

    public DynamicSaccharineLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties) {
        super(leavesProperties, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HONEY, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HONEY});
        super.createBlockStateDefinition(builder);
    }

    public int updateHydro(LevelAccessor accessor, BlockPos pos, BlockState state, boolean worldGen) {
        LeavesProperties leavesProperties = this.getLeavesProperties();
        int oldHydro = (Integer)state.getValue((Property)DISTANCE);
        if (!ChunkTreeHelper.canCheckSurroundings((LevelAccessor)accessor, (BlockPos)pos, (int)2)) {
            return oldHydro;
        }
        int newHydro = this.getHydrationLevelFromNeighbors(accessor, pos, leavesProperties);
        if (oldHydro != newHydro) {
            boolean decayed;
            BlockState placeState = this.getLeavesBlockStateForPlacementWithHoney(accessor, pos, state, leavesProperties.getDynamicLeavesState(newHydro), worldGen, oldHydro);
            boolean bl = decayed = newHydro == 0;
            int flag = decayed ? 3 : (this.appearanceChangesWithHydro(oldHydro, newHydro) ? 2 : 4);
            accessor.setBlock(pos, placeState, flag);
        }
        return newHydro;
    }

    @NotNull
    private BlockState getLeavesBlockStateForPlacementWithHoney(LevelAccessor accessor, BlockPos pos, BlockState oldState, BlockState newHydroState, boolean worldGen, int oldHydro) {
        if (oldState.hasProperty((Property)HONEY)) {
            int honey = (Integer)oldState.getValue((Property)HONEY);
            if (newHydroState.hasProperty((Property)HONEY)) {
                newHydroState = (BlockState)newHydroState.setValue((Property)HONEY, (Comparable)Integer.valueOf(honey));
            }
        }
        return this.getLeavesBlockStateForPlacement(accessor, pos, newHydroState, oldHydro, worldGen);
    }

    public boolean isEntityPassable(@Nullable Entity entity) {
        PokemonEntity pokemon;
        if (entity instanceof PokemonEntity && (pokemon = (PokemonEntity)entity).canPathThroughSaccLeaves()) {
            return true;
        }
        return super.isEntityPassable(entity);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (this.isEntityPassable((Entity)mob)) {
            return PathType.OPEN;
        }
        return super.getBlockPathType(state, level, pos, mob);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        SoundType defaultType = super.getSoundType(state, level, pos, entity);
        if (state.hasProperty((Property)HONEY) && (Integer)state.getValue((Property)HONEY) > 0) {
            return new SoundType(defaultType.volume, defaultType.pitch, defaultType.getBreakSound(), SoundEvents.HONEY_BLOCK_STEP, defaultType.getPlaceSound(), SoundEvents.HONEY_BLOCK_HIT, SoundEvents.HONEY_BLOCK_FALL);
        }
        return defaultType;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int currentAge = (Integer)state.getValue((Property)HONEY);
        if (currentAge > 0 && random.nextInt(2) == 0) {
            for (int i = 1; i <= 10; ++i) {
                int belowAge;
                BlockPos belowPos = pos.below(i);
                BlockState belowState = world.getBlockState(belowPos);
                if (belowState.isAir()) continue;
                if (!(belowState.getBlock() instanceof DynamicSaccharineLeavesBlock) || (belowAge = ((Integer)belowState.getValue((Property)HONEY)).intValue()) >= 2) break;
                world.setBlock(pos, this.changeAge(state, -1), 2);
                world.setBlock(belowPos, this.changeAge(belowState, 1), 2);
                break;
            }
        }
        super.randomTick(state, world, pos, random);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            boolean hasHoney;
            boolean bl = hasHoney = (Integer)state.getValue((Property)HONEY) > 0;
            if (!level.isClientSide()) {
                BlockState newState = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                if (hasHoney) {
                    newState = (BlockState)newState.setValue((Property)HONEY, (Comparable)Integer.valueOf(0));
                }
                level.setBlock(pos, newState, 3);
                level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            }
            if (hasHoney && level instanceof Level) {
                Level lvl = (Level)level;
                this.spawnDestroyHoneyParticles(lvl, pos, state);
            }
            return true;
        }
        return false;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        block3: {
            int particleCount;
            block2: {
                particleCount = random.nextInt(3);
                if ((Integer)state.getValue((Property)HONEY) != 1) break block2;
                for (int i = 0; i < particleCount; ++i) {
                    this.spawnHoneyParticles(level, pos, state, 0.025f);
                }
                break block3;
            }
            if ((Integer)state.getValue((Property)HONEY) != 2) break block3;
            for (int i = 0; i < particleCount; ++i) {
                this.spawnHoneyParticles(level, pos, state, 0.05f);
            }
        }
    }

    private void spawnHoneyParticles(Level level, BlockPos pos, BlockState state, float rate) {
        VoxelShape shape;
        double d;
        if (state.getFluidState().isEmpty() && level.random.nextFloat() < rate && (d = (shape = state.getShape((BlockGetter)level, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double e = shape.min(Direction.Axis.Y);
            if (e > 0.0) {
                this.addHoneyParticle(level, pos, shape, (double)pos.getY() + e - 0.05);
            } else {
                BlockPos below = pos.below();
                BlockState belowState = level.getBlockState(below);
                VoxelShape shape2 = belowState.getCollisionShape((BlockGetter)level, below);
                double f = shape2.max(Direction.Axis.Y);
                if ((f < 1.0 || !belowState.isSolidRender((BlockGetter)level, below)) && belowState.getFluidState().isEmpty()) {
                    this.addHoneyParticle(level, pos, shape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(Level level, BlockPos pos, VoxelShape shape, double height) {
        this.addHoneyParticle(level, (double)pos.getX() + shape.min(Direction.Axis.X), (double)pos.getX() + shape.max(Direction.Axis.X), (double)pos.getZ() + shape.min(Direction.Axis.Z), (double)pos.getZ() + shape.max(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(Level level, double minX, double maxX, double minZ, double maxZ, double height) {
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)level.random.nextDouble(), (double)minX, (double)maxX), height, Mth.lerp((double)level.random.nextDouble(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            ItemStack item = player.getItemInHand(hand);
            boolean isGlassBottle = item.is(Items.GLASS_BOTTLE);
            boolean isHoneyBottle = item.is(Items.HONEY_BOTTLE);
            if (isGlassBottle && !this.isAtMinAge(state)) {
                item.consume(1, (LivingEntity)player);
                player.addItem(new ItemStack((ItemLike)Items.HONEY_BOTTLE));
                level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS);
                level.setBlock(pos, (BlockState)state.setValue((Property)HONEY, (Comparable)Integer.valueOf(0)), 2);
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.SUCCESS;
            }
            if (isHoneyBottle && !this.isAtMaxAge(state)) {
                item.consume(1, (LivingEntity)player);
                level.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS);
                level.setBlock(pos, (BlockState)state.setValue((Property)HONEY, (Comparable)Integer.valueOf(2)), 2);
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    private boolean isAtMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)HONEY) == 2;
    }

    private boolean isAtMinAge(BlockState state) {
        return (Integer)state.getValue((Property)HONEY) == 0;
    }

    private BlockState changeAge(BlockState state, int value) {
        int newAge = Mth.clamp((int)((Integer)state.getValue((Property)HONEY) + value), (int)0, (int)2);
        return (BlockState)state.setValue((Property)HONEY, (Comparable)Integer.valueOf(newAge));
    }

    private void spawnDestroyHoneyParticles(Level level, BlockPos pos, BlockState state) {
        if (!this.isAtMinAge(state)) {
            int amount = this.isAtMaxAge(state) ? 30 : 10;
            for (int i = 0; i < amount; ++i) {
                double ox = level.random.nextDouble() * 1.2 - 0.6;
                double oy = level.random.nextDouble() * 1.2 - 0.6;
                double oz = level.random.nextDouble() * 1.2 - 0.6;
                level.addParticle((ParticleOptions)ParticleTypes.FALLING_HONEY, (double)pos.getX() + 0.5 + ox, (double)pos.getY() + 0.5 + oy, (double)pos.getZ() + 0.5 + oz, 0.0, 1.0, 0.0);
            }
        }
    }

    public void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        this.spawnDestroyHoneyParticles(level, pos, state);
        super.spawnDestroyParticles(level, player, pos, (BlockState)state.setValue((Property)HONEY, (Comparable)((Integer)state.getValue((Property)HONEY))));
    }
}

