/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dtcobblemon.model;

import com.dtteam.dtcobblemon.model.SlatheredBranchBlockModelGeometry;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlatheredBranchBlockModelLoader
implements IGeometryLoader<SlatheredBranchBlockModelGeometry> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String TEXTURES = "textures";
    private static final String BARK = "bark";
    private static final String SLATHERED = "slathered_textures";
    private static final String RINGS = "rings";

    public SlatheredBranchBlockModelGeometry read(JsonObject modelObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject textures = this.getTexturesObject(modelObject);
        return this.getModelGeometry(this.getBarkTextureLocation(textures), this.getRingsTextureLocation(textures), this.getSlatheredTexturesLocation(modelObject));
    }

    protected JsonObject getTexturesObject(JsonObject modelContents) {
        if (!modelContents.has(TEXTURES) || !modelContents.get(TEXTURES).isJsonObject()) {
            this.throwRequiresElement(TEXTURES, "Json Object");
        }
        return modelContents.getAsJsonObject(TEXTURES);
    }

    protected List<ResourceLocation> getSlatheredTexturesLocation(JsonObject object) {
        return this.getTextureLocations(object, SLATHERED);
    }

    protected ResourceLocation getBarkTextureLocation(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, BARK);
    }

    protected ResourceLocation getRingsTextureLocation(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, RINGS);
    }

    protected ResourceLocation getTextureLocation(JsonObject textureObject, String textureElement) {
        try {
            return this.getLocationOrThrow(this.getOrThrow(textureObject, textureElement));
        }
        catch (RuntimeException e) {
            LOGGER.error("{} missing or did not have valid \"{}\" texture location element, using missing texture.", (Object)this.getModelTypeName(), (Object)textureElement);
            return MissingTextureAtlasSprite.getLocation();
        }
    }

    protected List<ResourceLocation> getTextureLocations(JsonObject textureObject, String textureElement) {
        try {
            return this.getLocationsOrThrow(this.getArrayOrThrow(textureObject, textureElement));
        }
        catch (RuntimeException e) {
            LOGGER.error("{} missing or did not have valid \"{}\" texture location list element, using missing texture.", (Object)this.getModelTypeName(), (Object)textureElement);
            return List.of(MissingTextureAtlasSprite.getLocation());
        }
    }

    protected String getOrThrow(JsonObject jsonObject, String identifier) {
        if (jsonObject.get(identifier) == null || !jsonObject.get(identifier).isJsonPrimitive() || !jsonObject.get(identifier).getAsJsonPrimitive().isString()) {
            this.throwRequiresElement(identifier, "String");
        }
        return jsonObject.get(identifier).getAsString();
    }

    protected void throwRequiresElement(String element, String expectedType) {
        throw new RuntimeException(this.getModelTypeName() + " requires a valid \"" + element + "\" element of type " + expectedType + ".");
    }

    protected JsonArray getArrayOrThrow(JsonObject jsonObject, String identifier) {
        if (jsonObject.get(identifier) != null && jsonObject.get(identifier).isJsonPrimitive() && jsonObject.getAsJsonPrimitive(identifier).isString()) {
            JsonArray pseudoArray = new JsonArray();
            pseudoArray.add(this.getOrThrow(jsonObject, identifier));
            return pseudoArray;
        }
        if (jsonObject.get(identifier) == null || !jsonObject.get(identifier).isJsonArray()) {
            this.throwRequiresElement(identifier, "Array");
        }
        JsonArray array = jsonObject.get(identifier).getAsJsonArray();
        array.forEach(jsonElement -> {
            if (!jsonElement.isJsonPrimitive() || !jsonElement.getAsJsonPrimitive().isString()) {
                throw new RuntimeException(this.getModelTypeName() + " requires all elements of \"" + identifier + "\" to be of type String.");
            }
        });
        return array;
    }

    protected ResourceLocation getLocationOrThrow(String location) {
        try {
            return ResourceLocation.parse((String)location);
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<ResourceLocation> getLocationsOrThrow(JsonArray array) {
        try {
            LinkedList<ResourceLocation> locations = new LinkedList<ResourceLocation>();
            array.forEach(element -> locations.add(ResourceLocation.parse((String)element.getAsString())));
            return locations;
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getModelTypeName() {
        return "Slathered Branch";
    }

    protected SlatheredBranchBlockModelGeometry getModelGeometry(ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, List<ResourceLocation> slatheredTextureLocations) {
        return new SlatheredBranchBlockModelGeometry(barkTextureLocation, ringsTextureLocation, slatheredTextureLocations);
    }
}

